/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.core.auth;

import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;

public class CertificateCredentials
extends AuthenticationCredentials {
    private final String keyStoreFileName;
    private final String keyStoreType;
    private final String password;
    private final boolean savePassword;
    private final boolean hasSecrets;

    public CertificateCredentials(String keyStoreFileName, String password, String keyStoreType) {
        this(keyStoreFileName, password, keyStoreType, true, true);
    }

    public CertificateCredentials(String keyStoreFileName, String password, String keyStoreType, boolean savePassword) {
        this(keyStoreFileName, password, keyStoreType, savePassword, true);
    }

    CertificateCredentials(String keyStoreFileName, String password, String keyStoreType, boolean savePassword, boolean hasSecrets) {
        Assert.isNotNull((Object)password);
        this.keyStoreFileName = keyStoreFileName;
        this.password = password;
        this.keyStoreType = keyStoreType;
        this.savePassword = savePassword;
        this.hasSecrets = hasSecrets;
    }

    protected CertificateCredentials(ICredentialsStore store, String prefix, boolean loadSecrets) {
        this(store.get(String.valueOf(prefix) + ".keyStoreFileName", null), loadSecrets ? store.get(String.valueOf(prefix) + ".password", "") : "", store.get(String.valueOf(prefix) + ".keyStoreType", null), store.getBoolean(String.valueOf(prefix) + ".savePassword", false), loadSecrets);
    }

    public void clear(ICredentialsStore store, String prefix) {
        store.remove(String.valueOf(prefix) + ".keyStoreFileName");
        store.remove(String.valueOf(prefix) + ".password");
        store.remove(String.valueOf(prefix) + ".keyStoreType");
        store.remove(String.valueOf(prefix) + ".savePassword");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertificateCredentials other = (CertificateCredentials)obj;
        if (this.hasSecrets != other.hasSecrets) {
            return false;
        }
        if (this.keyStoreFileName == null ? other.keyStoreFileName != null : !this.keyStoreFileName.equals(other.keyStoreFileName)) {
            return false;
        }
        if (this.keyStoreType == null ? other.keyStoreType != null : !this.keyStoreType.equals(other.keyStoreType)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        return this.savePassword == other.savePassword;
    }

    public String getKeyStoreFileName() {
        return this.keyStoreFileName;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getSavePassword() {
        return this.savePassword;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.hasSecrets ? 1231 : 1237);
        result = 31 * result + (this.keyStoreFileName == null ? 0 : this.keyStoreFileName.hashCode());
        result = 31 * result + (this.keyStoreType == null ? 0 : this.keyStoreType.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.savePassword ? 1231 : 1237);
        return result;
    }

    public void save(ICredentialsStore store, String prefix) {
        store.put(String.valueOf(prefix) + ".keyStoreFileName", this.keyStoreFileName, false);
        if (this.hasSecrets) {
            store.put(String.valueOf(prefix) + ".password", this.password, true);
        }
        store.put(String.valueOf(prefix) + ".keyStoreType", this.keyStoreType, false);
        store.putBoolean(String.valueOf(prefix) + ".savePassword", this.savePassword, false);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CertificateCredentials [keyStoreFileName=");
        builder.append(this.keyStoreFileName);
        builder.append(", password=");
        builder.append(this.password == null ? this.password : "********");
        builder.append(", keyStoreType=");
        builder.append(this.keyStoreType);
        builder.append(", savePassword=");
        builder.append(this.savePassword);
        builder.append(", hasSecrets=");
        builder.append(this.hasSecrets);
        builder.append("]");
        return builder.toString();
    }
}

