/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.markup.block;

import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class BugzillaGeneratedCommentBlock
extends Block {
    private static Pattern pattern = Pattern.compile("\\s*\\*\\*\\*\\s+((This bug has been)|(Bug \\d+ has been)).*?\\*\\*\\*\\s*");

    public boolean canStart(String line, int lineOffset) {
        return lineOffset == 0 && line.length() > 0 && pattern.matcher(line).matches();
    }

    protected int processLineContent(String line, int offset) {
        Attributes attributes = new Attributes();
        attributes.setCssStyle("color: Blue;");
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, attributes);
        this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.state, line, offset);
        this.setClosed(true);
        return -1;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

