/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui.notifications;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationModel;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationService;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class NotificationsPlugin
extends AbstractUIPlugin {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.commons.notifications";
    public static final String PREF_NOTICATIONS_ENABLED = "notifications.enabled";
    private static NotificationsPlugin instance;
    private NotificationModel model;
    private NotificationService service;

    public static NotificationsPlugin getDefault() {
        return instance;
    }

    public NotificationModel createModelWorkingCopy() {
        XMLMemento memento = null;
        File file = this.getModelFile().toFile();
        if (file.exists()) {
            try {
                FileReader reader = new FileReader(file);
                try {
                    memento = XMLMemento.createReadRoot((Reader)reader);
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                this.getLog().log((IStatus)new Status(4, ID_PLUGIN, "Unexpected error restoring notification state", (Throwable)e));
            }
            catch (WorkbenchException e) {
                this.getLog().log((IStatus)new Status(4, ID_PLUGIN, "Unexpected error restoring notification state", (Throwable)e));
            }
        }
        return new NotificationModel((IMemento)memento);
    }

    public NotificationModel getModel() {
        if (this.model == null) {
            this.model = this.createModelWorkingCopy();
        }
        return this.model;
    }

    public NotificationService getService() {
        if (this.service == null) {
            this.service = new NotificationService();
        }
        return this.service;
    }

    public void saveModel() {
        if (this.model != null && this.model.isDirty()) {
            this.save(this.model);
        }
    }

    public void saveWorkingCopy(NotificationModel workingCopy) {
        XMLMemento memento = this.save(workingCopy);
        if (this.model != null) {
            this.model.initialize((IMemento)memento);
        }
    }

    public void start(BundleContext context) throws Exception {
        instance = this;
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        instance = null;
    }

    private XMLMemento save(NotificationModel model) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"notifications");
        model.save((IMemento)memento);
        try {
            FileWriter writer = new FileWriter(this.getModelFile().toFile());
            try {
                memento.save((Writer)writer);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            this.getLog().log((IStatus)new Status(4, ID_PLUGIN, "Unexpected error saving notification state", (Throwable)e));
        }
        return memento;
    }

    protected IPath getModelFile() {
        IPath stateLocation = Platform.getStateLocation((Bundle)this.getBundle());
        IPath cacheFile = stateLocation.append("notifications.xml");
        return cacheFile;
    }
}

