/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.sdk.java.search;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.sdk.java.search.ActiveSearchNotifier;
import org.eclipse.mylyn.context.sdk.util.search.ISearchPluginTest;
import org.eclipse.mylyn.internal.context.core.IActiveSearchListener;
import org.eclipse.mylyn.internal.context.core.IActiveSearchOperation;

public class SearchPluginTestHelper
extends TestCase {
    private final ISearchPluginTest test;
    private static final long MAXWAIT = 360L;

    public SearchPluginTestHelper(ISearchPluginTest test) {
        this.test = test;
    }

    public void searchResultsNotNull(ActiveSearchNotifier notifier, String handle, String kind, IInteractionElement searchNode, int dos, int expected, boolean includeOnlyJava) throws IOException, CoreException {
        notifier.mockRaiseInterest(handle, kind);
        List results = this.test.search(dos, searchNode);
        int size = results.size();
        if (includeOnlyJava) {
            size = 0;
            for (Object o : results) {
                if (!(o instanceof IJavaElement)) continue;
                ++size;
            }
        }
        SearchPluginTestHelper.assertNotNull((String)"Results Null", (Object)results);
        SearchPluginTestHelper.assertEquals((String)"Wrong number search results", (int)expected, (int)size);
        notifier.clearContext();
    }

    public void searchResultsNotNullInteresting(ActiveSearchNotifier notifier, String handle, String kind, IInteractionElement searchNode, int dos, int expected, boolean includeOnlyJava) throws IOException, CoreException {
        notifier.mockEditorSelection(handle, kind);
        List results = this.test.search(dos, searchNode);
        int size = results.size();
        if (includeOnlyJava) {
            size = 0;
            for (Object o : results) {
                if (!(o instanceof IJavaElement)) continue;
                ++size;
            }
        }
        SearchPluginTestHelper.assertNotNull((String)"Results Null", (Object)results);
        SearchPluginTestHelper.assertEquals((String)"Wrong number search results", (int)expected, (int)size);
        notifier.clearContext();
    }

    public void searchResultsNotNull(ActiveSearchNotifier notifier, IInteractionElement searchNode, int dos, int expected, boolean includeOnlyJava) throws IOException, CoreException {
        List results = this.test.search(dos, searchNode);
        int size = results.size();
        if (includeOnlyJava) {
            size = 0;
            for (Object o : results) {
                if (!(o instanceof IJavaElement)) continue;
                ++size;
            }
        }
        SearchPluginTestHelper.assertNotNull((String)"Results Null", (Object)results);
        SearchPluginTestHelper.assertEquals((String)"Wrong number search results", (int)expected, (int)size);
        notifier.clearContext();
    }

    public void searchResultsNull(ActiveSearchNotifier notifier, String handle, String kind, IInteractionElement searchNode, int dos) throws IOException, CoreException {
        notifier.mockRaiseInterest(handle, kind);
        List results = this.test.search(dos, searchNode);
        SearchPluginTestHelper.assertNull((String)"Results Not Null", (Object)results);
        notifier.clearContext();
    }

    public void searchResultsNull(ActiveSearchNotifier notifier, IInteractionElement searchNode, int dos) throws IOException, CoreException {
        List results = this.test.search(dos, searchNode);
        SearchPluginTestHelper.assertNull((String)"Results Not Null", (Object)results);
        notifier.clearContext();
    }

    public static long search(IActiveSearchOperation op, IActiveSearchListener listener) {
        if (op == null) {
            return -1L;
        }
        op.addListener(listener);
        long start = new Date().getTime();
        op.run((IProgressMonitor)new NullProgressMonitor());
        int i = 0;
        while ((long)i < 360L && !listener.resultsGathered()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        long time = (new Date().getTime() - start) / 1000L;
        if (!listener.resultsGathered()) {
            return -1L;
        }
        return time;
    }
}

