/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.state;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.ContextAwareEditorInput;
import org.eclipse.mylyn.context.ui.ContextUi;
import org.eclipse.mylyn.context.ui.IContextAwareEditor;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.state.ContextState;
import org.eclipse.mylyn.internal.context.ui.state.ContextStateParticipant;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorStateParticipant
extends ContextStateParticipant {
    public static final String MEMENTO_EDITORS = "org.eclipse.mylyn.context.ui.editors";
    private static final String KEY_MONITORED_WINDOW_OPEN_EDITORS = "MonitoredWindowOpenEditors";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_NUMER = "number";
    private static final String ATTRIBUTE_IS_LAUNCHING = "isLaunching";
    private static final String ATTRIBUTE_IS_ACTIVE = "isActive";
    private boolean previousCloseEditorsSetting = Workbench.getInstance().getPreferenceStore().getBoolean("REUSE_OPEN_EDITORS_BOOLEAN");
    private boolean enabled = true;
    private IMemento savedMemento;
    private String savedContextHandle;

    @Override
    public void saveDefaultState(ContextState memento) {
        Workbench workbench = (Workbench)PlatformUI.getWorkbench();
        this.previousCloseEditorsSetting = workbench.getPreferenceStore().getBoolean("REUSE_OPEN_EDITORS_BOOLEAN");
        workbench.getPreferenceStore().setValue("REUSE_OPEN_EDITORS_BOOLEAN", false);
    }

    @Override
    public void restoreState(ContextState state) {
        if (Workbench.getInstance().isStarting()) {
            return;
        }
        boolean wasPaused = ContextCore.getContextManager().isContextCapturePaused();
        try {
            try {
                if (!wasPaused) {
                    ContextCore.getContextManager().setContextCapturePaused(true);
                }
                String mementoString = null;
                IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                try {
                    IMemento memento;
                    this.savedMemento = memento = state.getMemento(MEMENTO_EDITORS);
                    this.savedContextHandle = state.getContextHandle();
                    if (memento != null) {
                        IMemento[] children = memento.getChildren(KEY_MONITORED_WINDOW_OPEN_EDITORS);
                        if (children.length > 0) {
                            IMemento[] iMementoArray = children;
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IMemento child = iMementoArray[n2];
                                WorkbenchPage page = this.getWorkbenchPageForMemento(child, activeWindow);
                                if (child != null && page != null) {
                                    this.restoreEditors(page, child, page.getWorkbenchWindow() == activeWindow);
                                }
                                ++n2;
                            }
                        } else {
                            WorkbenchPage page = (WorkbenchPage)activeWindow.getActivePage();
                            if (memento != null) {
                                this.restoreEditors(page, memento, true);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not restore all editors, memento: \"" + mementoString + "\"", (Throwable)e));
                }
                activeWindow.setActivePage(activeWindow.getActivePage());
                IInteractionElement activeNode = state.getContext().getActiveNode();
                if (activeNode != null) {
                    ContextUi.getUiBridge(activeNode.getContentType()).open(activeNode);
                }
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Failed to open editors on activation", (Throwable)e));
                ContextCore.getContextManager().setContextCapturePaused(false);
            }
        }
        finally {
            ContextCore.getContextManager().setContextCapturePaused(false);
        }
    }

    private WorkbenchPage getWorkbenchPageForMemento(IMemento memento, IWorkbenchWindow activeWindow) {
        Integer windowToRestorenumber;
        String windowToRestoreClassName = memento.getString(ATTRIBUTE_CLASS);
        if (windowToRestoreClassName == null) {
            windowToRestoreClassName = "";
        }
        if ((windowToRestorenumber = memento.getInteger(ATTRIBUTE_NUMER)) == null) {
            windowToRestorenumber = 0;
        }
        Set monitoredWindows = MonitorUi.getMonitoredWindows();
        for (IWorkbenchWindow window : monitoredWindows) {
            int windowNumber = this.getNumber(window);
            if (!window.getClass().getCanonicalName().equals(windowToRestoreClassName) || windowNumber != windowToRestorenumber) continue;
            return (WorkbenchPage)window.getActivePage();
        }
        Boolean isActive = memento.getBoolean(ATTRIBUTE_IS_ACTIVE);
        if (isActive == null) {
            isActive = false;
        }
        boolean shouldRestoreUnknownWindowToActive = true;
        boolean shouldRestoreActiveWindowToActive = true;
        if (isActive.booleanValue() && shouldRestoreActiveWindowToActive) {
            return (WorkbenchPage)activeWindow.getActivePage();
        }
        if (shouldRestoreUnknownWindowToActive) {
            return (WorkbenchPage)activeWindow.getActivePage();
        }
        if (shouldRestoreActiveWindowToActive && shouldRestoreUnknownWindowToActive) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Unable to find window to restore memento to.", (Throwable)new Exception()));
        }
        return null;
    }

    @Override
    public void saveState(ContextState state, boolean allowModifications) {
        IMemento memento;
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        if (allowModifications) {
            this.closeContextAwareEditors(state.getContextHandle());
        }
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchWindow launchingWindow = MonitorUi.getLaunchingWorkbenchWindow();
        Set monitoredWindows = MonitorUi.getMonitoredWindows();
        boolean failed = false;
        XMLMemento newMemento = XMLMemento.createWriteRoot((String)MEMENTO_EDITORS);
        for (IWorkbenchWindow window : monitoredWindows) {
            IMemento memento2 = newMemento.createChild(KEY_MONITORED_WINDOW_OPEN_EDITORS);
            memento2.putString(ATTRIBUTE_CLASS, window.getClass().getCanonicalName());
            int number = this.getNumber(window);
            memento2.putInteger(ATTRIBUTE_NUMER, number);
            memento2.putBoolean(ATTRIBUTE_IS_LAUNCHING, window == launchingWindow);
            memento2.putBoolean(ATTRIBUTE_IS_ACTIVE, window == activeWindow);
            try {
                this.saveEditors_e_3_x((WorkbenchPage)window.getActivePage(), memento2);
            }
            catch (Exception exception) {
                this.saveEditors_e_4((WorkbenchPage)window.getActivePage(), memento2);
                failed = true;
            }
        }
        if (failed && this.savedMemento != null && this.savedContextHandle != null && this.savedContextHandle.equals(state.getContextHandle())) {
            memento = state.createMemento(MEMENTO_EDITORS);
            memento.putMemento(this.savedMemento);
        } else {
            memento = state.createMemento(MEMENTO_EDITORS);
            memento.putMemento((IMemento)newMemento);
        }
        this.savedMemento = null;
    }

    private void saveEditors_e_4(WorkbenchPage activePage, IMemento memento) {
    }

    private void saveEditors_e_3_x(WorkbenchPage page, IMemento memento) throws Exception {
        Method getEditorManagerMethod = WorkbenchPage.class.getDeclaredMethod("getEditorManager", new Class[0]);
        Object editorManager = getEditorManagerMethod.invoke((Object)page, new Object[0]);
        Method getEditorsMethod = editorManager.getClass().getDeclaredMethod("saveState", IMemento.class);
        getEditorsMethod.invoke(editorManager, memento);
    }

    private int getNumber(IWorkbenchWindow window) {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            if (windows[i] == window) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public void restoreDefaultState(ContextState memento) {
        Workbench.getInstance().getPreferenceStore().setValue("REUSE_OPEN_EDITORS_BOOLEAN", this.previousCloseEditorsSetting);
        this.closeAllEditors();
    }

    @Override
    public void clearState(String contextHandle, boolean activeContext) {
        if (activeContext) {
            this.closeAllEditors();
        }
    }

    private void restoreEditors(WorkbenchPage page, IMemento memento, boolean isActiveWindow) {
        ArrayList visibleEditors = new ArrayList(5);
        IEditorReference[] activeEditor = new IEditorReference[1];
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, "", null);
        try {
            IWorkbenchPart editor;
            IMemento[] editorMementos = memento.getChildren("editor");
            LinkedHashSet<IMemento> editorMementoSet = new LinkedHashSet<IMemento>();
            editorMementoSet.addAll(Arrays.asList(editorMementos));
            try {
                this.restoreEditors_e_3_x(page, visibleEditors, activeEditor, result, editorMementoSet);
            }
            catch (Exception exception) {
                this.restoreEditors_e_4(page, visibleEditors, activeEditor, result, editorMementoSet);
            }
            if (activeEditor[0] != null && isActiveWindow && (editor = activeEditor[0].getPart(true)) != null) {
                page.activate(editor);
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not restore editors", (Throwable)e));
        }
    }

    private void restoreEditors_e_4(WorkbenchPage page, ArrayList<?> visibleEditors, IEditorReference[] activeEditor, MultiStatus result, Set<IMemento> editorMementoSet) {
    }

    private void restoreEditors_e_3_x(WorkbenchPage page, ArrayList<?> visibleEditors, IEditorReference[] activeEditor, MultiStatus result, Set<IMemento> editorMementoSet) throws Exception {
        Method getEditorManagerMethod = WorkbenchPage.class.getDeclaredMethod("getEditorManager", new Class[0]);
        Object editorManager = getEditorManagerMethod.invoke((Object)page, new Object[0]);
        Method getEditorsMethod = editorManager.getClass().getDeclaredMethod("getEditors", new Class[0]);
        List<IEditorReference> alreadyVisibleEditors = Arrays.asList((IEditorReference[])getEditorsMethod.invoke(editorManager, new Object[0]));
        HashSet<String> restoredPartNames = new HashSet<String>();
        for (IEditorReference editorReference : alreadyVisibleEditors) {
            restoredPartNames.add(editorReference.getPartName());
        }
        Method restoreEditorStateMethod = editorManager.getClass().getDeclaredMethod("restoreEditorState", IMemento.class, ArrayList.class, IEditorReference[].class, MultiStatus.class);
        for (IMemento editorMemento : editorMementoSet) {
            String partName = editorMemento.getString("partName");
            if (!restoredPartNames.contains(partName)) {
                restoreEditorStateMethod.invoke(editorManager, editorMemento, visibleEditors, activeEditor, result);
                continue;
            }
            restoredPartNames.add(partName);
        }
        Method setVisibleEditorMethod = editorManager.getClass().getDeclaredMethod("setVisibleEditor", IEditorReference.class, Boolean.TYPE);
        int i = 0;
        while (i < visibleEditors.size()) {
            setVisibleEditorMethod.invoke(editorManager, visibleEditors.get(i), false);
            ++i;
        }
    }

    public void closeContextAwareEditors(String contextHandle) {
        try {
            if (PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            for (IWorkbenchWindow window : MonitorUi.getMonitoredWindows()) {
                IWorkbenchPage page = window.getActivePage();
                if (page == null) continue;
                IEditorReference[] references = page.getEditorReferences();
                ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>();
                IEditorReference[] iEditorReferenceArray = references;
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference reference = iEditorReferenceArray[n2];
                    if (this.canClose(reference)) {
                        try {
                            IEditorInput input = reference.getEditorInput();
                            if (this.shouldForceClose(input, contextHandle)) {
                                toClose.add(reference);
                            }
                        }
                        catch (PartInitException partInitException) {}
                    }
                    ++n2;
                }
                page.closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), true);
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not auto close editor", t));
        }
    }

    public void closeAllEditors() {
        try {
            if (PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            for (IWorkbenchWindow window : MonitorUi.getMonitoredWindows()) {
                IWorkbenchPage page = window.getActivePage();
                if (page == null) continue;
                IEditorReference[] references = page.getEditorReferences();
                ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>();
                IEditorReference[] iEditorReferenceArray = references;
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference reference = iEditorReferenceArray[n2];
                    if (this.canClose(reference)) {
                        toClose.add(reference);
                    }
                    ++n2;
                }
                page.closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), true);
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not auto close editor", t));
        }
    }

    private boolean shouldForceClose(final IEditorInput input, final String contextHandle) {
        final AtomicBoolean result = new AtomicBoolean();
        SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                ContextAwareEditorInput inputContext = (ContextAwareEditorInput)input.getAdapter(ContextAwareEditorInput.class);
                result.set(inputContext != null && inputContext.forceClose(contextHandle));
            }

            public void handleException(Throwable e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Failed to verify editor status", e));
            }
        });
        return result.get();
    }

    private boolean canClose(IEditorReference editorReference) {
        final IEditorPart editor = editorReference.getEditor(false);
        if (editor != null) {
            final boolean[] result = new boolean[]{true};
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    if (editor instanceof IContextAwareEditor) {
                        result[0] = ((IContextAwareEditor)editor).canClose();
                    } else {
                        IContextAwareEditor contextAware = (IContextAwareEditor)editor.getAdapter(IContextAwareEditor.class);
                        if (contextAware != null) {
                            result[0] = contextAware.canClose();
                        }
                    }
                }

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Failed to verify editor status", e));
                }
            });
            return result[0];
        }
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editors.auto.manage");
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

