/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.editor;

import com.google.gerrit.common.data.GerritConfig;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.ui.operations.GerritOperationDialog;
import org.eclipse.mylyn.internal.tasks.ui.actions.SynchronizeEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorSection;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractGerritSection
extends AbstractTaskEditorSection {
    public Label addTextClient(FormToolkit toolkit, Section section, String text) {
        return this.addTextClient(toolkit, section, text, true);
    }

    public Label addTextClient(FormToolkit toolkit, final Section section, String text, boolean hideOnExpand) {
        final Label label = new Label((Composite)section, 0);
        label.setText("  " + text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        section.setTextClient((Control)label);
        if (hideOnExpand) {
            label.setVisible(!section.isExpanded());
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    label.setVisible(!section.isExpanded());
                }
            });
        }
        return label;
    }

    protected Shell getShell() {
        return this.getTaskEditorPage().getSite().getShell();
    }

    protected ITask getTask() {
        return this.getTaskEditorPage().getTask();
    }

    protected void openOperationDialog(GerritOperationDialog dialog) {
        if (dialog.open() == 0) {
            SynchronizeEditorAction action = new SynchronizeEditorAction();
            action.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getTaskEditorPage().getEditor()));
            action.run();
        }
    }

    protected GerritConfig getConfig() {
        return GerritCorePlugin.getGerritClient((TaskRepository)this.getTaskEditorPage().getTaskRepository()).getGerritConfig();
    }
}

