/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.editor;

import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.common.data.PatchSetPublishDetail;
import com.google.gerrit.reviewdb.ApprovalCategory;
import com.google.gerrit.reviewdb.Patch;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.UserIdentity;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.fetch.FetchGerritChangeWizard;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.GerritTaskSchema;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.ReviewItemCache;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritPatchSetContent;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailX;
import org.eclipse.mylyn.internal.gerrit.core.egit.GerritToGitMapping;
import org.eclipse.mylyn.internal.gerrit.ui.GerritReviewBehavior;
import org.eclipse.mylyn.internal.gerrit.ui.editor.AbstractGerritSection;
import org.eclipse.mylyn.internal.gerrit.ui.editor.ComparePatchSetJob;
import org.eclipse.mylyn.internal.gerrit.ui.editor.FetchPatchSetJob;
import org.eclipse.mylyn.internal.gerrit.ui.editor.GetPatchSetContentJob;
import org.eclipse.mylyn.internal.gerrit.ui.editor.OpenPatchSetJob;
import org.eclipse.mylyn.internal.gerrit.ui.editor.ReviewItemLabelProvider;
import org.eclipse.mylyn.internal.gerrit.ui.egit.EGitUiUtil;
import org.eclipse.mylyn.internal.gerrit.ui.operations.AbandonDialog;
import org.eclipse.mylyn.internal.gerrit.ui.operations.PublishDialog;
import org.eclipse.mylyn.internal.gerrit.ui.operations.RestoreDialog;
import org.eclipse.mylyn.internal.gerrit.ui.operations.SubmitDialog;
import org.eclipse.mylyn.internal.reviews.ui.compare.FileItemCompareEditorInput;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.statushandlers.StatusManager;

public class PatchSetSection
extends AbstractGerritSection {
    private Composite composite;
    private final List<Job> jobs;
    private FormToolkit toolkit;
    private int addedDrafts;
    private final ReviewItemCache cache;

    public PatchSetSection() {
        this.setPartName("Patch Sets");
        this.jobs = new ArrayList<Job>();
        this.cache = new ReviewItemCache();
    }

    public void dispose() {
        for (Job job : this.jobs) {
            job.cancel();
        }
        super.dispose();
    }

    public void updateTextClient(Section section, PatchSetDetail patchSetDetail, boolean cachingInProgress) {
        String time = DateFormat.getDateTimeInstance().format(patchSetDetail.getPatchSet().getCreatedOn());
        int numComments = this.getNumComments(patchSetDetail);
        String message = numComments > 0 ? NLS.bind((String)"{0}, {1} Comments", (Object)time, (Object)numComments) : NLS.bind((String)"{0}", (Object)time);
        if (cachingInProgress) {
            message = String.valueOf(message) + " [Caching contents...]";
        }
        Label textClientLabel = (Label)section.getTextClient();
        textClientLabel.setText("  " + message);
        textClientLabel.getParent().layout(true, true);
    }

    public void initialize(AbstractTaskEditorPage taskEditorPage) {
        super.initialize(taskEditorPage);
    }

    private Composite createActions(final ChangeDetail changeDetail, final PatchSetDetail patchSetDetail, final PatchSetPublishDetail publishDetail, Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        RowLayout layout = new RowLayout();
        layout.center = true;
        layout.spacing = 10;
        buttonComposite.setLayout((Layout)layout);
        boolean canPublish = this.getTaskData().getAttributeMapper().getBooleanValue(this.getTaskData().getRoot().getAttribute(GerritTaskSchema.getDefault().CAN_PUBLISH.getKey()));
        boolean canSubmit = false;
        if (changeDetail.getCurrentActions() != null) {
            canSubmit = changeDetail.getCurrentActions().contains(ApprovalCategory.SUBMIT);
        } else if (changeDetail instanceof ChangeDetailX) {
            canSubmit = ((ChangeDetailX)changeDetail).canSubmit();
        }
        if (canPublish) {
            Button publishButton = this.toolkit.createButton(buttonComposite, "Publish Comments...", 8);
            publishButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PatchSetSection.this.doPublish(publishDetail);
                }
            });
        }
        Button fetchButton = this.toolkit.createButton(buttonComposite, "Fetch...", 8);
        fetchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatchSetSection.this.doFetch(changeDetail, patchSetDetail);
            }
        });
        final Composite compareComposite = this.toolkit.createComposite(buttonComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo(compareComposite);
        Button compareButton = this.toolkit.createButton(compareComposite, "Compare With Base", 8);
        compareButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatchSetSection.this.doCompareWith(changeDetail, null, patchSetDetail.getPatchSet());
            }
        });
        if (changeDetail.getPatchSets().size() > 1) {
            Button compareWithButton = this.toolkit.createButton(compareComposite, "", 8);
            GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)compareWithButton);
            compareWithButton.setImage(WorkbenchImages.getImage((String)"IMG_LCL_BUTTON_MENU"));
            compareWithButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.showCompareMenu(compareComposite, changeDetail, patchSetDetail);
                }

                private void showCompareMenu(Composite compareComposite2, ChangeDetail changeDetail2, PatchSetDetail patchSetDetail2) {
                    Menu menu = new Menu((Control)compareComposite2);
                    Point p = compareComposite2.getLocation();
                    p.y += compareComposite2.getSize().y;
                    p = compareComposite2.getParent().toDisplay(p);
                    PatchSetSection.this.fillCompareWithMenu(changeDetail2, patchSetDetail2, menu);
                    menu.setLocation(p);
                    menu.setVisible(true);
                }
            });
        }
        if (canSubmit) {
            Button submitButton = this.toolkit.createButton(buttonComposite, "Submit", 8);
            submitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PatchSetSection.this.doSubmit(patchSetDetail.getPatchSet());
                }
            });
        }
        if (changeDetail != null && changeDetail.isCurrentPatchSet(patchSetDetail)) {
            if (changeDetail.canAbandon()) {
                Button abondonButton = this.toolkit.createButton(buttonComposite, "Abandon...", 8);
                abondonButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PatchSetSection.this.doAbandon(patchSetDetail.getPatchSet());
                    }
                });
            } else if (changeDetail.canRestore()) {
                Button restoreButton = this.toolkit.createButton(buttonComposite, "Restore...", 8);
                restoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PatchSetSection.this.doRestore(patchSetDetail.getPatchSet());
                    }
                });
            }
        }
        return buttonComposite;
    }

    void fillCompareWithMenu(ChangeDetail changeDetail, PatchSetDetail patchSetDetail, Menu menu) {
        for (PatchSet patchSet : changeDetail.getPatchSets()) {
            if (patchSet.getPatchSetId() == patchSetDetail.getPatchSet().getPatchSetId()) continue;
            CompareAction action = new CompareAction(changeDetail, patchSet, patchSetDetail.getPatchSet());
            action.fill(menu);
        }
    }

    private void createSubSection(final ChangeDetail changeDetail, final PatchSetDetail patchSetDetail, final PatchSetPublishDetail publishDetail, Section section) {
        int style = 8210;
        if (changeDetail.isCurrentPatchSet(patchSetDetail)) {
            style |= 0x40;
        }
        final Section subSection = this.toolkit.createSection(this.composite, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)subSection);
        subSection.setText(NLS.bind((String)"Patch Set {0}", (Object)patchSetDetail.getPatchSet().getId().get()));
        subSection.setTitleBarForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.addTextClient(this.toolkit, subSection, "", false);
        this.updateTextClient(subSection, patchSetDetail, false);
        if (subSection.isExpanded()) {
            this.createSubSectionContents(changeDetail, patchSetDetail, publishDetail, subSection);
        }
        subSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (subSection.getClient() == null) {
                    PatchSetSection.this.createSubSectionContents(changeDetail, patchSetDetail, publishDetail, subSection);
                }
            }
        });
    }

    private int getNumComments(PatchSetDetail patchSetDetail) {
        int numComments = 0;
        for (Patch patch : patchSetDetail.getPatches()) {
            numComments += patch.getCommentCount();
        }
        return numComments;
    }

    private void subSectionExpanded(final ChangeDetail changeDetail, final PatchSetDetail patchSetDetail, final Section composite, final Viewer viewer) {
        this.updateTextClient(composite, patchSetDetail, true);
        final GetPatchSetContentJob job = new GetPatchSetContentJob(this.getTaskEditorPage().getTaskRepository(), patchSetDetail);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PatchSetSection.this.getControl() != null && !PatchSetSection.this.getControl().isDisposed()) {
                            GerritPatchSetContent content;
                            if (event.getResult().isOK() && (content = job.getPatchSetContent()) != null && content.getPatchScriptByPatchKey() != null) {
                                viewer.setInput((Object)GerritUtil.createInput((ChangeDetail)changeDetail, (GerritPatchSetContent)content, (ReviewItemCache)PatchSetSection.this.cache));
                            }
                            PatchSetSection.this.updateTextClient(composite, patchSetDetail, false);
                            PatchSetSection.this.getTaskEditorPage().reflow();
                        }
                    }
                });
            }
        });
        this.jobs.add(job);
        job.schedule();
    }

    protected Control createContent(FormToolkit toolkit, Composite parent) {
        this.toolkit = toolkit;
        this.composite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 5).applyTo(this.composite);
        GerritChange change = GerritUtil.getChange((TaskData)this.getTaskData());
        if (change != null) {
            for (PatchSetDetail patchSetDetail : change.getPatchSetDetails()) {
                PatchSet.Id patchSetId = patchSetDetail.getPatchSet().getId();
                PatchSetPublishDetail publishDetail = (PatchSetPublishDetail)change.getPublishDetailByPatchSetId().get(patchSetId);
                this.createSubSection((ChangeDetail)change.getChangeDetail(), patchSetDetail, publishDetail, this.getSection());
            }
        }
        return this.composite;
    }

    protected void doAbandon(PatchSet patchSet) {
        AbandonDialog dialog = new AbandonDialog(this.getShell(), this.getTask(), patchSet);
        this.openOperationDialog(dialog);
    }

    protected void doPublish(PatchSetPublishDetail publishDetail) {
        PublishDialog dialog = new PublishDialog(this.getShell(), this.getTask(), publishDetail, this.addedDrafts);
        this.openOperationDialog(dialog);
    }

    protected void doFetch(ChangeDetail changeDetail, PatchSetDetail patchSetDetail) {
        GerritToGitMapping mapping = this.getRepository(changeDetail);
        if (mapping != null) {
            String refName = patchSetDetail.getPatchSet().getRefName();
            FetchGerritChangeWizard wizard = new FetchGerritChangeWizard(mapping.getRepository(), refName);
            WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            wizardDialog.setHelpAvailable(false);
            wizardDialog.open();
        }
    }

    private GerritToGitMapping getRepository(ChangeDetail changeDetail) {
        GerritToGitMapping mapper = new GerritToGitMapping(this.getTaskEditorPage().getTaskRepository(), this.getConfig(), this.getGerritProject(changeDetail));
        try {
            if (mapper.find() != null) {
                return mapper;
            }
            if (mapper.getGerritProject() != null) {
                int response;
                boolean create = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Clone Git Repository", (String)"The referenced Git repository was not found in the workspace. Clone Git repository?");
                if (create && (response = EGitUiUtil.openCloneRepositoryWizard(this.getShell(), this.getTaskEditorPage().getTaskRepository(), mapper.getGerritProject())) == 0 && mapper.find() != null) {
                    return mapper;
                }
            } else {
                String message = NLS.bind((String)"No Git repository found for fetching Gerrit change {0}", (Object)this.getTask().getTaskKey());
                String reason = NLS.bind((String)"No remote config found that has fetch URL with host ''{0}'' and path matching ''{1}''", (Object)mapper.getGerritHost(), (Object)mapper.getGerritProjectName());
                GerritCorePlugin.logError((String)message, null);
                ErrorDialog.openError((Shell)this.getShell(), (String)"Gerrit Fetch Change Error", (String)message, (IStatus)new Status(4, "org.eclipse.mylyn.gerrit.ui", reason));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.mylyn.gerrit.ui", "Error accessing Git repository", (Throwable)e);
            StatusManager.getManager().handle((IStatus)status, 7);
        }
        return null;
    }

    protected void doCompareWithInSynchronizeView(ChangeDetail changeDetail, PatchSet base, PatchSet target) {
        GerritToGitMapping mapping = this.getRepository(changeDetail);
        if (mapping != null) {
            ComparePatchSetJob job = new ComparePatchSetJob(mapping.getRepository(), mapping.getRemote(), base, target);
            job.schedule();
        }
    }

    protected void doCompareWith(ChangeDetail changeDetail, PatchSet base, PatchSet target) {
        OpenPatchSetJob job = new OpenPatchSetJob(this.getTaskEditorPage().getTaskRepository(), this.getTask(), changeDetail, base, target, this.cache);
        job.schedule();
    }

    private String getGerritProject(ChangeDetail changeDetail) {
        return changeDetail.getChange().getProject().get();
    }

    protected void doRestore(PatchSet patchSet) {
        RestoreDialog dialog = new RestoreDialog(this.getShell(), this.getTask(), patchSet);
        this.openOperationDialog(dialog);
    }

    protected void doSubmit(PatchSet patchSet) {
        SubmitDialog dialog = new SubmitDialog(this.getShell(), this.getTask(), patchSet);
        this.openOperationDialog(dialog);
    }

    protected boolean shouldExpandOnCreate() {
        return true;
    }

    void createSubSectionContents(final ChangeDetail changeDetail, final PatchSetDetail patchSetDetail, PatchSetPublishDetail publishDetail, Section subSection) {
        Composite composite = this.toolkit.createComposite((Composite)subSection);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        subSection.setClient((Control)composite);
        Label authorLabel = new Label(composite, 0);
        authorLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        authorLabel.setText("Author");
        Text authorText = new Text(composite, 8);
        authorText.setText(GerritUtil.getUserLabel((UserIdentity)patchSetDetail.getInfo().getAuthor()));
        Label committerLabel = new Label(composite, 0);
        committerLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        committerLabel.setText("Committer");
        Text committerText = new Text(composite, 8);
        committerText.setText(GerritUtil.getUserLabel((UserIdentity)patchSetDetail.getInfo().getCommitter()));
        Label commitLabel = new Label(composite, 0);
        commitLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        commitLabel.setText("Commit");
        Hyperlink commitLink = new Hyperlink(composite, 8);
        commitLink.setText(patchSetDetail.getPatchSet().getRevision().get());
        commitLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                GerritToGitMapping mapping = PatchSetSection.this.getRepository(changeDetail);
                if (mapping != null) {
                    final FetchPatchSetJob job = new FetchPatchSetJob("Opening Commit Viewer", mapping.getRepository(), mapping.getRemote(), patchSetDetail.getPatchSet());
                    job.schedule();
                    job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    CommitEditor.openQuiet((RepositoryCommit)job.getCommit());
                                }
                            });
                        }
                    });
                }
            }
        });
        Label refLabel = new Label(composite, 0);
        refLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        refLabel.setText("Ref");
        Text refText = new Text(composite, 8);
        refText.setText(patchSetDetail.getPatchSet().getRefName());
        final TableViewer viewer = new TableViewer(composite, 268438020);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).hint(500, -1).applyTo(viewer.getControl());
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private EContentAdapter modelAdapter;

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return this.getReviewItems(inputElement).toArray();
            }

            private List<IReviewItem> getReviewItems(Object inputElement) {
                if (inputElement instanceof IReviewItemSet) {
                    return ((IReviewItemSet)inputElement).getItems();
                }
                return Collections.emptyList();
            }

            public void inputChanged(final Viewer viewer, Object oldInput, Object newInput) {
                if (this.modelAdapter != null) {
                    for (IReviewItem item : this.getReviewItems(oldInput)) {
                        ((EObject)item).eAdapters().remove((Object)this.modelAdapter);
                    }
                    PatchSetSection.this.addedDrafts = 0;
                }
                if (newInput instanceof IReviewItemSet) {
                    this.modelAdapter = new EContentAdapter(){

                        public void notifyChanged(Notification notification) {
                            super.notifyChanged(notification);
                            if (notification.getFeatureID(IReviewItem.class) == 4 && notification.getEventType() == 3) {
                                viewer.refresh();
                                PatchSetSection patchSetSection = PatchSetSection.this;
                                patchSetSection.addedDrafts = patchSetSection.addedDrafts + 1;
                            }
                        }
                    };
                    for (IReviewItem item : this.getReviewItems(newInput)) {
                        ((EObject)item).eAdapters().add((Object)this.modelAdapter);
                    }
                }
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ReviewItemLabelProvider()));
        viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IFileItem item = (IFileItem)selection.getFirstElement();
                PatchSetSection.this.doOpen((IReviewItemSet)viewer.getInput(), item);
            }
        });
        IReviewItemSet itemSet = GerritUtil.createInput((ChangeDetail)changeDetail, (GerritPatchSetContent)new GerritPatchSetContent(patchSetDetail), (ReviewItemCache)this.cache);
        viewer.setInput((Object)itemSet);
        Composite actionComposite = this.createActions(changeDetail, patchSetDetail, publishDetail, composite);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)actionComposite);
        this.subSectionExpanded(changeDetail, patchSetDetail, subSection, (Viewer)viewer);
        this.getTaskEditorPage().reflow();
    }

    private void doOpen(IReviewItemSet items, IFileItem item) {
        if (item.getBase() == null || item.getTarget() == null) {
            this.getTaskEditorPage().getEditor().setMessage("The selected file is not available, yet", 2);
            return;
        }
        GerritReviewBehavior behavior = new GerritReviewBehavior(this.getTask());
        CompareConfiguration configuration = new CompareConfiguration();
        CompareUI.openCompareEditor((CompareEditorInput)new FileItemCompareEditorInput(configuration, item, (ReviewBehavior)behavior));
    }

    private class CompareAction
    extends Action {
        private final PatchSet base;
        private final PatchSet target;
        private final ChangeDetail changeDetail;

        public CompareAction(ChangeDetail changeDetail, PatchSet base, PatchSet target) {
            this.changeDetail = changeDetail;
            this.base = base;
            this.target = target;
        }

        public void fill(Menu menu) {
            MenuItem item = new MenuItem(menu, 0);
            item.setText(NLS.bind((String)"Compare with Patch Set {0}", (Object)this.base.getPatchSetId()));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CompareAction.this.run();
                }
            });
        }

        public void run() {
            PatchSetSection.this.doCompareWith(this.changeDetail, this.base, this.target);
        }
    }
}

