/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.util.css;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.core.util.css.Block;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CompositeSelector;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssClassSelector;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssParser;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssRule;
import org.eclipse.mylyn.internal.wikitext.core.util.css.DescendantSelector;
import org.eclipse.mylyn.internal.wikitext.core.util.css.IdSelector;
import org.eclipse.mylyn.internal.wikitext.core.util.css.NameSelector;
import org.eclipse.mylyn.internal.wikitext.core.util.css.Selector;
import org.eclipse.mylyn.internal.wikitext.core.util.css.Stylesheet;
import org.eclipse.mylyn.wikitext.tests.TestUtil;

public class CssParserTest
extends TestCase {
    private CssParser parser;

    protected void setUp() throws Exception {
        super.setUp();
        this.parser = new CssParser();
    }

    public void testDetectStyles() {
        String css = "a: b and more; c: d ; e: fg; h i: j";
        String[] expectedRuleNames = new String[]{"a", "c", "e", "i"};
        String[] expectedRuleValues = new String[]{"b and more", "d", "fg", "j"};
        Iterator ruleIterator = this.parser.createRuleIterator(css);
        int count = 0;
        while (ruleIterator.hasNext()) {
            CssRule rule = (CssRule)ruleIterator.next();
            CssParserTest.assertEquals((String)expectedRuleNames[++count - 1], (String)rule.name);
            CssParserTest.assertEquals((String)expectedRuleValues[count - 1], (String)rule.value);
        }
        CssParserTest.assertEquals((int)expectedRuleNames.length, (int)count);
    }

    public void testSimple() throws IOException {
        Stylesheet stylesheet = this.parser.parse(this.readFully(String.valueOf(CssParserTest.class.getSimpleName()) + "_0.css"));
        CssParserTest.assertNotNull((Object)stylesheet);
        CssParserTest.assertEquals((int)25, (int)stylesheet.getBlocks().size());
    }

    private String readFully(String resourceName) throws IOException {
        InputStream stream = CssParserTest.class.getResourceAsStream(resourceName);
        try {
            int i;
            InputStreamReader reader = new InputStreamReader(stream);
            StringWriter writer = new StringWriter();
            while ((i = ((Reader)reader).read()) != -1) {
                writer.write(i);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            stream.close();
        }
    }

    public void testSimpleId() {
        Selector selector = this.parser.parseSelector("#id");
        CssParserTest.assertNotNull((Object)selector);
        TestUtil.println(selector);
        CssParserTest.assertEquals(IdSelector.class, selector.getClass());
        CssParserTest.assertEquals((String)"id", (String)((IdSelector)selector).getId());
    }

    public void testSimpleClass() {
        Selector selector = this.parser.parseSelector(".className");
        CssParserTest.assertNotNull((Object)selector);
        TestUtil.println(selector);
        CssParserTest.assertEquals(CssClassSelector.class, selector.getClass());
        CssParserTest.assertEquals((String)"className", (String)((CssClassSelector)selector).getCssClass());
    }

    public void testSimpleElement() {
        Selector selector = this.parser.parseSelector("body");
        CssParserTest.assertNotNull((Object)selector);
        TestUtil.println(selector);
        CssParserTest.assertEquals(NameSelector.class, selector.getClass());
        CssParserTest.assertEquals((String)"body", (String)((NameSelector)selector).getName());
    }

    public void testNumericElementName() {
        Selector selector = this.parser.parseSelector("h1");
        CssParserTest.assertNotNull((Object)selector);
        TestUtil.println("testNumericElementName: " + selector);
        CssParserTest.assertEquals(NameSelector.class, selector.getClass());
        CssParserTest.assertEquals((String)"h1", (String)((NameSelector)selector).getName());
    }

    public void testCompoundIdElement() {
        Selector selector = this.parser.parseSelector("#foo a");
        CssParserTest.assertNotNull((Object)selector);
        TestUtil.println("testCompoundIdElement: " + selector);
        CssParserTest.assertEquals(CompositeSelector.class, selector.getClass());
        CompositeSelector compositeSelector = (CompositeSelector)selector;
        CssParserTest.assertTrue((boolean)compositeSelector.isAnd());
        CssParserTest.assertEquals((int)2, (int)compositeSelector.getComponents().size());
        Selector firstComponent = (Selector)compositeSelector.getComponents().get(0);
        CssParserTest.assertEquals(DescendantSelector.class, firstComponent.getClass());
        Selector ancestorSelector = ((DescendantSelector)firstComponent).getAncestorSelector();
        CssParserTest.assertEquals(IdSelector.class, ancestorSelector.getClass());
        CssParserTest.assertEquals((String)"foo", (String)((IdSelector)ancestorSelector).getId());
        Selector secondComponent = (Selector)compositeSelector.getComponents().get(1);
        CssParserTest.assertEquals(NameSelector.class, secondComponent.getClass());
        CssParserTest.assertEquals((String)"a", (String)((NameSelector)secondComponent).getName());
    }

    public void testCompoundIdElement2() {
        Selector selector = this.parser.parseSelector("#foo, a");
        CssParserTest.assertNotNull((Object)selector);
        TestUtil.println(selector);
        CssParserTest.assertEquals(CompositeSelector.class, selector.getClass());
        CompositeSelector compositeSelector = (CompositeSelector)selector;
        CssParserTest.assertFalse((boolean)compositeSelector.isAnd());
        CssParserTest.assertEquals((int)2, (int)compositeSelector.getComponents().size());
        Selector firstComponent = (Selector)compositeSelector.getComponents().get(0);
        CssParserTest.assertEquals(IdSelector.class, firstComponent.getClass());
        CssParserTest.assertEquals((String)"foo", (String)((IdSelector)firstComponent).getId());
        Selector secondComponent = (Selector)compositeSelector.getComponents().get(1);
        CssParserTest.assertEquals(NameSelector.class, secondComponent.getClass());
        CssParserTest.assertEquals((String)"a", (String)((NameSelector)secondComponent).getName());
    }

    public void testCompoundElementWithJoin() {
        Selector selector = this.parser.parseSelector("table tr");
        CssParserTest.assertNotNull((Object)selector);
        TestUtil.println(selector);
        CssParserTest.assertEquals(CompositeSelector.class, selector.getClass());
        CompositeSelector compositeSelector = (CompositeSelector)selector;
        CssParserTest.assertTrue((boolean)compositeSelector.isAnd());
        CssParserTest.assertEquals((int)2, (int)compositeSelector.getComponents().size());
        Selector firstComponent = (Selector)compositeSelector.getComponents().get(0);
        CssParserTest.assertEquals(DescendantSelector.class, firstComponent.getClass());
        Selector ancestorSelector = ((DescendantSelector)firstComponent).getAncestorSelector();
        CssParserTest.assertEquals(NameSelector.class, ancestorSelector.getClass());
        CssParserTest.assertEquals((String)"table", (String)((NameSelector)ancestorSelector).getName());
        Selector secondComponent = (Selector)compositeSelector.getComponents().get(1);
        CssParserTest.assertEquals(NameSelector.class, secondComponent.getClass());
        CssParserTest.assertEquals((String)"tr", (String)((NameSelector)secondComponent).getName());
    }

    public void testCompoundElementUsingDot() {
        Selector selector = this.parser.parseSelector("table.summaryTable");
        CssParserTest.assertNotNull((Object)selector);
        TestUtil.println(selector);
        CssParserTest.assertEquals(CompositeSelector.class, selector.getClass());
        CompositeSelector compositeSelector = (CompositeSelector)selector;
        CssParserTest.assertTrue((boolean)compositeSelector.isAnd());
        CssParserTest.assertEquals((int)2, (int)compositeSelector.getComponents().size());
        Selector firstComponent = (Selector)compositeSelector.getComponents().get(0);
        CssParserTest.assertEquals(NameSelector.class, firstComponent.getClass());
        CssParserTest.assertEquals((String)"table", (String)((NameSelector)firstComponent).getName());
        Selector secondComponent = (Selector)compositeSelector.getComponents().get(1);
        CssParserTest.assertEquals(CssClassSelector.class, secondComponent.getClass());
        CssParserTest.assertEquals((String)"summaryTable", (String)((CssClassSelector)secondComponent).getCssClass());
    }

    public void testCompoundElementUsingDotAndJoin() {
        Selector selector = this.parser.parseSelector("table.summaryTable tr.a1");
        CssParserTest.assertNotNull((Object)selector);
        TestUtil.println("testCompoundElementUsingDotAndJoin: " + selector);
        CssParserTest.assertEquals(CompositeSelector.class, selector.getClass());
        CompositeSelector compositeSelector = (CompositeSelector)selector;
        CssParserTest.assertTrue((boolean)compositeSelector.isAnd());
        CssParserTest.assertEquals((int)2, (int)compositeSelector.getComponents().size());
    }

    public void testComments() {
        Stylesheet stylesheet = this.parser.parse("tr { /* font-size: 115%; */ font-size: 100%; } /* foo { sdf: sdf; } */");
        List blocks = stylesheet.getBlocks();
        CssParserTest.assertEquals((int)1, (int)blocks.size());
        Block block = (Block)blocks.get(0);
        List rules = block.getRules();
        CssParserTest.assertEquals((int)1, (int)rules.size());
        CssRule rule = (CssRule)rules.get(0);
        CssParserTest.assertEquals((String)"font-size", (String)rule.name);
        CssParserTest.assertEquals((String)"100%", (String)rule.value);
    }
}

