/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.syntax;

import java.util.ArrayList;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.AbstractDocumentTest;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.FastMarkupPartitioner;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.MarkupTokenScanner;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.tests.HeadRequired;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

@HeadRequired
public class MarkupTokenScannerTest
extends AbstractDocumentTest {
    private MarkupTokenScanner tokenScanner;

    protected void setUp() throws Exception {
        super.setUp();
        Font normalFont = new Font(null, new FontData[]{new FontData("normalFont", 12, 0)});
        Font monospaceFont = new Font(null, new FontData[]{new FontData("monoFont", 12, 0)});
        this.tokenScanner = new MarkupTokenScanner(normalFont, monospaceFont);
    }

    public void testTextileLinkWithStyle() {
        Document document = new Document();
        FastMarkupPartitioner partitioner = new FastMarkupPartitioner();
        partitioner.setMarkupLanguage((MarkupLanguage)new TextileLanguage());
        String markup = "\"_text_\":http://example.com";
        document.set(markup);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        partitioner.computePartitioning(0, document.getLength(), false);
        this.tokenScanner.setRange((IDocument)document, 0, document.getLength());
        ArrayList<MarkupTokenScanner.Token> tokens = new ArrayList<MarkupTokenScanner.Token>();
        IToken token = this.tokenScanner.nextToken();
        while (token != Token.EOF) {
            TestUtil.println(token);
            tokens.add((MarkupTokenScanner.Token)token);
            token = this.tokenScanner.nextToken();
        }
        MarkupTokenScannerTest.assertEquals((int)3, (int)tokens.size());
        MarkupTokenScannerTest.assertEquals((int)0, (int)((MarkupTokenScanner.Token)tokens.get(0)).getOffset());
        MarkupTokenScannerTest.assertEquals((int)1, (int)((MarkupTokenScanner.Token)tokens.get(0)).getLength());
        MarkupTokenScannerTest.assertFalse((boolean)((MarkupTokenScanner.Token)tokens.get(0)).getFontState().isItalic());
        MarkupTokenScannerTest.assertEquals((int)1, (int)((MarkupTokenScanner.Token)tokens.get(1)).getOffset());
        MarkupTokenScannerTest.assertEquals((int)6, (int)((MarkupTokenScanner.Token)tokens.get(1)).getLength());
        MarkupTokenScannerTest.assertTrue((boolean)((MarkupTokenScanner.Token)tokens.get(1)).getFontState().isItalic());
        MarkupTokenScannerTest.assertEquals((int)7, (int)((MarkupTokenScanner.Token)tokens.get(2)).getOffset());
        MarkupTokenScannerTest.assertEquals((int)20, (int)((MarkupTokenScanner.Token)tokens.get(2)).getLength());
        MarkupTokenScannerTest.assertFalse((boolean)((MarkupTokenScanner.Token)tokens.get(2)).getFontState().isItalic());
    }
}

