/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.markup.token;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.ImpliedHyperlinkReplacementToken;

public class ImpliedHyperlinkReplacementTokenTest
extends TestCase {
    private Pattern pattern;
    private ImpliedHyperlinkReplacementToken token;

    protected void setUp() throws Exception {
        super.setUp();
        this.token = new ImpliedHyperlinkReplacementToken();
        this.pattern = Pattern.compile(this.token.getPattern(0));
    }

    public void testGroupCount() {
        ImpliedHyperlinkReplacementTokenTest.assertEquals((int)this.token.getPatternGroupCount(), (int)this.pattern.matcher("").groupCount());
    }

    public void testSimple() {
        String url = "http://www.eclipse.org";
        this.testFind(url, 0, url.length());
    }

    public void testSimpleAtNonZeroOffset() {
        String url = " http://www.eclipse.org ";
        this.testFind(url, 1, url.length() - 2);
    }

    public void testSimpleEndingWithDot() {
        String url = "http://www.eclipse.org.";
        this.testFind(url, 0, url.length() - 1);
    }

    public void testSimpleEndingWithComma() {
        String url = "http://www.eclipse.org,";
        this.testFind(url, 0, url.length() - 1);
    }

    public void testSimpleEndingWithParen() {
        String url = "http://www.eclipse.org)";
        this.testFind(url, 0, url.length() - 1);
    }

    public void testUrlWithParams() {
        String url = "http://www.eclipse.org/wiki?one=two&three=four";
        this.testFind(url, 0, url.length());
    }

    public void testUrlWithPercentHex() {
        String url = "http://www.eclipse.org/%20/bar";
        this.testFind(url, 0, url.length());
    }

    public void testUrlWithSpace() {
        String url = "http://www.eclipse.org/+/bar";
        this.testFind(url, 0, url.length());
    }

    public void testUrlWithHttps() {
        String url = "https://www.eclipse.org/";
        this.testFind(url, 0, url.length());
    }

    public void testUrlWithHash() {
        String url = "http://www.eclipse.org/#anchor";
        this.testFind(url, 0, url.length());
    }

    private void testFind(String url, int offset, int length) {
        Matcher matcher = this.pattern.matcher(url);
        if (matcher.find()) {
            int start = matcher.start(1);
            int end = matcher.end(1);
            ImpliedHyperlinkReplacementTokenTest.assertEquals((int)offset, (int)start);
            ImpliedHyperlinkReplacementTokenTest.assertEquals((int)length, (int)(end - start));
        } else {
            ImpliedHyperlinkReplacementTokenTest.fail((String)("expected to find url at offset " + offset));
        }
    }
}

