/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util.anttask;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.core.WikiTextPlugin;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

public abstract class AbstractTestAntTask
extends TestCase {
    protected File tempFolder;
    protected String languageName = this.computeLanguageName();

    protected void setUp() throws Exception {
        super.setUp();
        this.tempFolder = File.createTempFile(((Object)((Object)this)).getClass().getSimpleName(), ".tmp");
        this.tempFolder.delete();
        this.tempFolder.mkdirs();
    }

    private String computeLanguageName() {
        if (WikiTextPlugin.getDefault() == null) {
            return TextileLanguage.class.getName();
        }
        return "Textile";
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.delete(this.tempFolder);
    }

    protected void delete(File f) {
        File[] files;
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.delete(child);
                ++n2;
            }
        }
        f.delete();
    }

    protected String getContent(File file) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), "utf-8");
        try {
            int i;
            StringWriter writer = new StringWriter();
            while ((i = ((Reader)reader).read()) != -1) {
                writer.write(i);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    protected void listFiles() {
        this.listFiles("", this.tempFolder);
    }

    private void listFiles(String prefix, File dir) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            TestUtil.println(String.format("%s: %s", String.valueOf(prefix) + file.getName(), file.isFile() ? "File" : "Folder"));
            if (file.isDirectory()) {
                this.listFiles(String.valueOf(prefix) + file.getName() + "/", file);
            }
            ++n2;
        }
    }
}

