/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.ui.dialogs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CredentialsDialog
extends TitleAreaDialog {
    private String domain;
    private Image keyLockImage;
    private String keyStoreFileName;
    private final Mode mode;
    private boolean needsDomain;
    private String password;
    private boolean savePassword;
    private String username;

    public CredentialsDialog(Shell parentShell, Mode mode) {
        super(parentShell);
        this.mode = mode;
        this.domain = "";
        this.username = "";
        this.password = "";
        this.keyStoreFileName = "";
    }

    public boolean close() {
        if (this.keyLockImage != null) {
            this.keyLockImage.dispose();
        }
        return super.close();
    }

    public String getDomain() {
        return this.domain;
    }

    public String getKeyStoreFileName() {
        return this.keyStoreFileName;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getSavePassword() {
        return this.savePassword;
    }

    public String getUserName() {
        return this.username;
    }

    public boolean needsDomain() {
        return this.needsDomain;
    }

    public void setDomain(String domain) {
        Assert.isNotNull((Object)domain);
        this.domain = domain;
    }

    public void setKeyStoreFileName(String keyStoreFileName) {
        Assert.isNotNull((Object)this.keyStoreFileName);
        this.keyStoreFileName = keyStoreFileName;
    }

    public void setNeedsDomain(boolean needsDomain) {
        this.needsDomain = needsDomain;
    }

    public void setPassword(String password) {
        Assert.isNotNull((Object)password);
        this.password = password;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public void setUsername(String username) {
        Assert.isNotNull((Object)username);
        this.username = username;
    }

    private void createCenterArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        if (this.mode == Mode.USER) {
            this.createUserControls(composite);
        } else if (this.mode == Mode.KEY_STORE) {
            this.createKeyStoreControls(composite);
        }
        this.createPasswordControls(composite);
    }

    private void createKeyStoreControls(Composite composite) {
        new Label(composite, 0).setText("Key Store:");
        final Text keyStoreField = new Text(composite, 2048);
        keyStoreField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CredentialsDialog.this.keyStoreFileName = keyStoreField.getText();
            }
        });
        keyStoreField.setText(this.keyStoreFileName);
        if (this.keyStoreFileName.length() == 0) {
            keyStoreField.setFocus();
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(this.convertHorizontalDLUsToPixels(200), -1).grab(true, false).applyTo((Control)keyStoreField);
        Button browseButton = new Button(composite, 8);
        browseButton.setText("Browse...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String returnFile;
                FileDialog fileDialog = new FileDialog(CredentialsDialog.this.getShell(), 4096);
                if (CredentialsDialog.this.keyStoreFileName != null) {
                    fileDialog.setFilterPath(System.getProperty("user.home", "."));
                }
                if ((returnFile = fileDialog.open()) != null) {
                    CredentialsDialog.this.username = returnFile;
                    keyStoreField.setText(returnFile);
                }
            }
        });
    }

    private void createPasswordControls(Composite composite) {
        new Label(composite, 0).setText("Password:");
        final Text passwordField = new Text(composite, 0x400800);
        passwordField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CredentialsDialog.this.password = passwordField.getText();
            }
        });
        passwordField.setText(this.password);
        if (this.username.length() > 0) {
            passwordField.setFocus();
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).hint(this.convertHorizontalDLUsToPixels(200), -1).grab(true, false).applyTo((Control)passwordField);
        final Button savePasswordButton = new Button(composite, 32);
        savePasswordButton.setText("Save Password");
        savePasswordButton.setSelection(this.savePassword);
        savePasswordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CredentialsDialog.this.savePassword = savePasswordButton.getSelection();
            }
        });
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)savePasswordButton);
    }

    private void createUserControls(Composite composite) {
        new Label(composite, 0).setText("Username:");
        final Text usernameText = new Text(composite, 2048);
        usernameText.setText(this.username);
        usernameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CredentialsDialog.this.username = usernameText.getText();
            }
        });
        if (this.username.length() == 0) {
            usernameText.setFocus();
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(this.convertHorizontalDLUsToPixels(200), -1).span(2, 1).grab(true, false).applyTo((Control)usernameText);
        if (this.needsDomain()) {
            new Label(composite, 0).setText("Domain:");
            final Text domainText = new Text(composite, 2048);
            domainText.setText(this.domain);
            domainText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CredentialsDialog.this.domain = domainText.getText();
                }
            });
            GridDataFactory.fillDefaults().align(4, 0x1000000).hint(this.convertHorizontalDLUsToPixels(200), -1).span(2, 1).grab(true, false).applyTo((Control)domainText);
        }
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText("Enter credentials");
        this.setTitle("Authentication");
        Control control = super.createContents(parent);
        this.keyLockImage = CommonImages.BANNER_SECURE_ROLE.createImage();
        this.setTitleImage(this.keyLockImage);
        CredentialsDialog.applyDialogFont((Control)control);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parent2 = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parent2, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)composite);
        this.createCenterArea(composite);
        composite.pack();
        return parent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        KEY_STORE,
        USER;

    }
}

