/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.commons.ui.CommonsUiPlugin;
import org.eclipse.mylyn.internal.commons.ui.Messages;
import org.eclipse.mylyn.internal.provisional.commons.ui.AdaptiveRefreshPolicy;
import org.eclipse.mylyn.internal.provisional.commons.ui.EnhancedFilteredTree;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

@Deprecated
public abstract class AbstractFilteredTree
extends EnhancedFilteredTree {
    private static final int FILTER_WIDTH_MIN = 60;
    private static final int FILTER_WIDTH_MAX = 300;
    private static final float FILTER_WIDTH_RATIO = 0.35f;
    public static final String LABEL_FIND = Messages.AbstractFilteredTree_Find;
    private WorkbenchJob refreshJob;
    private AdaptiveRefreshPolicy refreshPolicy;
    private Composite progressComposite;
    private Composite searchComposite;
    private boolean showProgress = false;
    private String previousFilterText;

    public AbstractFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, treeStyle, filter, true);
        try {
            this.refreshPolicy = new AdaptiveRefreshPolicy((Job)this.refreshJob);
        }
        catch (Exception e) {
            CommonsUiPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.commons.ui", "Could not get refresh job", (Throwable)e));
        }
        this.setInitialText(LABEL_FIND);
    }

    protected WorkbenchJob doCreateRefreshJob() {
        this.refreshJob = super.doCreateRefreshJob();
        return this.refreshJob;
    }

    protected void createControl(Composite parent, int treeStyle) {
        super.createControl(parent, treeStyle);
        GridLayout layout = (GridLayout)this.getLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
    }

    protected Control createTreeControl(Composite parent, int style) {
        this.progressComposite = this.createProgressComposite(parent);
        this.searchComposite = this.createSearchComposite(parent);
        if (this.searchComposite != null) {
            this.searchComposite.setVisible(false);
            ((GridData)this.searchComposite.getLayoutData()).exclude = true;
        }
        return super.createTreeControl(parent, style);
    }

    protected Composite createFilterControls(final Composite parent) {
        this.filterComposite = new Composite(parent.getParent(), 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 3;
        gridLayout.marginTop = 5;
        gridLayout.marginBottom = 3;
        gridLayout.verticalSpacing = 0;
        this.filterComposite.setLayout((Layout)gridLayout);
        super.createFilterControls(parent);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).hint(60, -1).minSize(60, -1).applyTo((Control)parent);
        this.filterComposite.addControlListener((ControlListener)new ControlAdapter(){
            boolean handlingEvents;

            public void controlResized(ControlEvent e) {
                if (this.handlingEvents) {
                    return;
                }
                try {
                    this.handlingEvents = true;
                    Point size = parent.getParent().getSize();
                    int width = Math.max(60, (int)((float)size.x * 0.35f));
                    int offset = 1;
                    if (parent.getParent().getLayoutData() instanceof GridData) {
                        offset = ((GridLayout)parent.getParent().getLayout()).marginWidth + ((GridLayout)parent.getParent().getLayout()).marginLeft + ((GridLayout)parent.getParent().getLayout()).horizontalSpacing;
                    }
                    ((GridData)parent.getLayoutData()).widthHint = Math.min(width, 300) + offset;
                    ((GridData)((AbstractFilteredTree)AbstractFilteredTree.this).filterText.getParent().getLayoutData()).widthHint = Math.min(width, 300);
                    parent.getParent().layout();
                }
                finally {
                    this.handlingEvents = false;
                }
            }
        });
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b' && e.doit) {
                    AbstractFilteredTree.this.setFilterText("");
                }
            }
        });
        ((GridData)this.filterText.getLayoutData()).verticalAlignment = 0x1000000;
        parent.setParent(this.filterComposite);
        Composite workingSetComposite = this.createActiveWorkingSetComposite(this.filterComposite);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)workingSetComposite);
        Composite activeTaskComposite = this.createActiveTaskComposite(this.filterComposite);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(true, false).applyTo((Control)activeTaskComposite);
        gridLayout.numColumns = this.filterComposite.getChildren().length;
        return parent;
    }

    protected abstract Composite createProgressComposite(Composite var1);

    protected abstract Composite createActiveWorkingSetComposite(Composite var1);

    protected abstract Composite createActiveTaskComposite(Composite var1);

    protected Composite createSearchComposite(Composite container) {
        return null;
    }

    protected void textChanged() {
        String text = this.getFilterString();
        if (text == null || text.equals(this.previousFilterText)) {
            return;
        }
        super.textChanged();
        this.previousFilterText = text;
        if (this.refreshPolicy != null) {
            if (LABEL_FIND.equals(text) && !this.useNewLook) {
                this.clearText();
                this.refreshPolicy.textChanged("");
            } else {
                this.refreshPolicy.textChanged(text);
            }
        }
        this.updateToolbar(true);
    }

    @Deprecated
    protected Job getRefreshJob() {
        return this.refreshJob;
    }

    public AdaptiveRefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
        this.progressComposite.setVisible(showProgress);
        ((GridData)this.progressComposite.getLayoutData()).exclude = !showProgress;
        this.getParent().getParent().layout(true, true);
    }

    public void setShowSearch(boolean showSearch) {
        if (this.searchComposite != null) {
            this.searchComposite.setVisible(showSearch);
            ((GridData)this.searchComposite.getLayoutData()).exclude = !showSearch;
            this.getParent().getParent().layout(true, true);
        }
    }
}

