/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.versions.core.spi;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.versions.core.ScmArtifact;
import org.eclipse.mylyn.versions.core.spi.ScmConnector;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;

public class ScmResourceArtifact
extends ScmArtifact {
    private final IResource resource;
    private final ScmConnector connector;

    public ScmResourceArtifact(ScmConnector connector, IResource resource, String id, String path) {
        super(id, path);
        this.connector = connector;
        this.resource = resource;
        this.setProjectName(resource.getProject().getName());
        this.setProjectRelativePath(resource.getProjectRelativePath().toPortableString());
    }

    public ScmResourceArtifact(ScmConnector connector, IResource resource, String id) {
        this(connector, resource, id, resource.getFullPath().toString());
    }

    public IFileRevision getFileRevision(IProgressMonitor monitor) {
        return this.getFileHistory(monitor).getFileRevision(this.getId());
    }

    public IFileHistory getFileHistory(IProgressMonitor monitor) {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)this.resource.getProject(), (String)this.connector.getProviderId());
        IFileHistory history = provider.getFileHistoryProvider().getFileHistoryFor(this.resource, 0, monitor);
        return history;
    }

    public IFileRevision[] getContributors(IProgressMonitor monitor) {
        IFileHistory history = this.getFileHistory(monitor);
        IFileRevision fileRevision = history.getFileRevision(this.getId());
        return fileRevision != null ? history.getContributors(fileRevision) : null;
    }

    public IFileRevision[] getTargets(IProgressMonitor monitor) {
        IFileHistory history = this.getFileHistory(monitor);
        IFileRevision fileRevision = history.getFileRevision(this.getId());
        return fileRevision != null ? history.getTargets(fileRevision) : null;
    }
}

