/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.net.UnsupportedRequestException;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryDelta;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryLocation;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.dialogs.TaskRepositoryCredentialsDialog;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TaskRepositoryLocationUi
extends TaskRepositoryLocation {
    private static Object lock = new Object();

    public TaskRepositoryLocationUi(TaskRepository taskRepository) {
        super(taskRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCredentials(AuthenticationType authType, String message, IProgressMonitor monitor) throws UnsupportedRequestException {
        if (CoreUtil.TEST_MODE) {
            throw new UnsupportedRequestException();
        }
        AuthenticationCredentials oldCredentials = this.taskRepository.getCredentials(authType);
        Object object = lock;
        synchronized (object) {
            if (!this.areEqual(oldCredentials, this.taskRepository.getCredentials(authType))) {
                return;
            }
            if (Policy.isBackgroundMonitor((IProgressMonitor)monitor)) {
                throw new UnsupportedRequestException();
            }
            PasswordRunner runner = new PasswordRunner(authType, message);
            if (!PlatformUI.getWorkbench().getDisplay().isDisposed()) {
                PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)runner);
                if (runner.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (!runner.isChanged()) {
                    throw new UnsupportedRequestException();
                }
            } else {
                throw new UnsupportedRequestException();
            }
        }
    }

    private boolean areEqual(AuthenticationCredentials oldCredentials, AuthenticationCredentials credentials) {
        if (oldCredentials == null) {
            return credentials == null;
        }
        return oldCredentials.equals((Object)credentials);
    }

    private class PasswordRunner
    implements Runnable {
        private final AuthenticationType authType;
        private boolean changed;
        private final String message;
        private boolean canceled;

        public PasswordRunner(AuthenticationType credentialType, String message) {
            this.authType = credentialType;
            this.message = message;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void run() {
            Shell shell = WorkbenchUtil.getShell();
            if (shell != null && !shell.isDisposed()) {
                TaskRepositoryCredentialsDialog dialog = TaskRepositoryCredentialsDialog.createDialog(shell);
                this.initializeDialog(dialog);
                int resultCode = dialog.open();
                if (resultCode == 0) {
                    this.apply(dialog);
                    this.changed = true;
                } else if (resultCode == 1000) {
                    this.changed = true;
                } else {
                    this.canceled = true;
                }
            }
        }

        private void initializeDialog(TaskRepositoryCredentialsDialog dialog) {
            dialog.setTaskRepository(TaskRepositoryLocationUi.this.taskRepository);
            dialog.setFileDialog(AuthenticationType.CERTIFICATE.equals((Object)this.authType));
            AuthenticationCredentials credentials = TaskRepositoryLocationUi.this.taskRepository.getCredentials(this.authType);
            if (credentials != null) {
                dialog.setUsername(credentials.getUserName());
                dialog.setPassword(credentials.getPassword());
            }
            if (this.message != null) {
                dialog.setMessage(this.message);
            } else {
                dialog.setMessage(this.getDefaultMessage());
            }
        }

        private String getDefaultMessage() {
            if (AuthenticationType.REPOSITORY.equals((Object)this.authType)) {
                return Messages.TaskRepositoryLocationUi_Enter_repository_password;
            }
            if (AuthenticationType.CERTIFICATE.equals((Object)this.authType)) {
                return Messages.TaskRepositoryLocationUi_Enter_CLIENTCERTIFICATE_password;
            }
            if (AuthenticationType.HTTP.equals((Object)this.authType)) {
                return Messages.TaskRepositoryLocationUi_Enter_HTTP_password;
            }
            if (AuthenticationType.PROXY.equals((Object)this.authType)) {
                return Messages.TaskRepositoryLocationUi_Enter_proxy_password;
            }
            return null;
        }

        private void apply(TaskRepositoryCredentialsDialog dialog) {
            AuthenticationCredentials credentials = new AuthenticationCredentials(dialog.getUserName(), dialog.getPassword());
            TaskRepositoryLocationUi.this.taskRepository.setCredentials(this.authType, credentials, dialog.getSavePassword());
            TasksUiPlugin.getRepositoryManager().notifyRepositorySettingsChanged(TaskRepositoryLocationUi.this.taskRepository, new TaskRepositoryDelta(TaskRepositoryDelta.Type.CREDENTIALS, (Object)this.authType));
        }
    }
}

