/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.commands;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.mylyn.internal.tasks.ui.ITaskAttachmentViewer;
import org.eclipse.mylyn.internal.tasks.ui.TaskAttachmentViewerManager;
import org.eclipse.mylyn.internal.tasks.ui.commands.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenTaskAttachmentWithMenu
extends ContributionItem {
    private final TaskAttachmentViewerManager manager = new TaskAttachmentViewerManager();

    public OpenTaskAttachmentWithMenu() {
    }

    public OpenTaskAttachmentWithMenu(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        List<ITaskAttachmentViewer> viewers;
        List<ITaskAttachment> attachments = AttachmentUtil.getSelectedAttachments(null);
        if (attachments.isEmpty() || attachments.size() > 1) {
            return;
        }
        ITaskAttachment attachment = attachments.get(0);
        String viewerId = this.manager.getPreferredViewerID(attachment);
        int itemsAdded = 0;
        ITaskAttachmentViewer viewer = this.manager.getBrowserViewer(attachment);
        if (viewer != null) {
            itemsAdded = this.addItems(menu, index, Collections.singletonList(viewer), attachments, viewerId);
            index += itemsAdded;
        }
        if ((viewers = this.manager.getWorkbenchViewers(attachment)).size() > 0) {
            itemsAdded = this.addSeparator(menu, index, itemsAdded);
            index += itemsAdded;
            itemsAdded = this.addItems(menu, index, viewers, attachments, viewerId);
            index += itemsAdded;
        }
        if ((viewers = this.manager.getSystemViewers(attachment)).size() > 0) {
            itemsAdded = this.addSeparator(menu, index, itemsAdded);
            index += itemsAdded;
            itemsAdded = this.addItems(menu, index, viewers, attachments, viewerId);
            index += itemsAdded;
        }
    }

    protected int addSeparator(Menu menu, int index, int itemsAdded) {
        if (itemsAdded > 0) {
            new MenuItem(menu, 2, index);
            return 1;
        }
        return 0;
    }

    protected int addItems(Menu menu, int index, List<ITaskAttachmentViewer> viewers, List<ITaskAttachment> attachments, String viewerId) {
        int i = 0;
        for (ITaskAttachmentViewer viewer : viewers) {
            MenuItem item = new MenuItem(menu, 16, index + i);
            item.setText(viewer.getLabel());
            item.addSelectionListener((SelectionListener)new RunAssociatedViewer(viewer, attachments));
            if (viewerId != null && viewerId.equals(viewer.getId())) {
                item.setSelection(true);
            }
            ++i;
        }
        return i;
    }

    public boolean isDynamic() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RunAssociatedViewer
    extends SelectionAdapter {
        private final ITaskAttachmentViewer viewer;
        private final List<ITaskAttachment> attachments;

        RunAssociatedViewer(ITaskAttachmentViewer handler, List<ITaskAttachment> attachments) {
            this.attachments = attachments;
            this.viewer = handler;
        }

        public void widgetSelected(SelectionEvent event) {
            IWorkbenchPage page;
            if (!((MenuItem)event.widget).getSelection()) {
                return;
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null) {
                try {
                    for (ITaskAttachment attachment : this.attachments) {
                        OpenTaskAttachmentWithMenu.this.manager.savePreferredViewerID(attachment, this.viewer.getId());
                        try {
                            this.viewer.openAttachment(page, attachment);
                        }
                        catch (CoreException e) {
                            TasksUiInternal.logAndDisplayStatus(Messages.OpenTaskAttachmentHandler_failedToOpenViewer, e.getStatus());
                        }
                    }
                }
                catch (OperationCanceledException operationCanceledException) {}
            }
        }
    }
}

