/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.ui.editors.BooleanAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.DateAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.DoubleAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.LongTextAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.MultiSelectionAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.PersonAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewerConfiguration;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.SingleSelectionAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorExtensions;
import org.eclipse.mylyn.internal.tasks.ui.editors.TextAttributeEditor;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorExtension;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorToolkit;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.services.IServiceLocator;

public class AttributeEditorFactory {
    private final TaskDataModel model;
    private final TaskRepository taskRepository;
    private final IServiceLocator serviceLocator;
    private AttributeEditorToolkit editorToolkit;

    public AttributeEditorFactory(TaskDataModel model, TaskRepository taskRepository) {
        this(model, taskRepository, null);
    }

    public AttributeEditorFactory(TaskDataModel model, TaskRepository taskRepository, IServiceLocator serviceLocator) {
        Assert.isNotNull((Object)model);
        Assert.isNotNull((Object)taskRepository);
        this.model = model;
        this.taskRepository = taskRepository;
        this.serviceLocator = serviceLocator;
    }

    public AttributeEditorToolkit getEditorToolkit() {
        return this.editorToolkit;
    }

    public void setEditorToolkit(AttributeEditorToolkit editorToolkit) {
        this.editorToolkit = editorToolkit;
    }

    public AbstractAttributeEditor createEditor(String type, TaskAttribute taskAttribute) {
        Assert.isNotNull((Object)type);
        if ("boolean".equals(type)) {
            return new BooleanAttributeEditor(this.model, taskAttribute);
        }
        if ("date".equals(type)) {
            return new DateAttributeEditor(this.model, taskAttribute);
        }
        if ("dateTime".equals(type)) {
            DateAttributeEditor editor = new DateAttributeEditor(this.model, taskAttribute);
            editor.setShowTime(true);
            return editor;
        }
        if ("person".equals(type)) {
            return new PersonAttributeEditor(this.model, taskAttribute);
        }
        if ("longRichText".equals(type)) {
            AbstractTaskEditorExtension extension;
            IContextService contextService;
            RichTextAttributeEditor editor = null;
            if (this.serviceLocator != null && (contextService = (IContextService)this.serviceLocator.getService(IContextService.class)) != null && (extension = TaskEditorExtensions.getTaskEditorExtension(this.model.getTaskRepository())) != null) {
                editor = new RichTextAttributeEditor(this.model, this.taskRepository, taskAttribute, 2, contextService, extension);
            }
            if (editor == null) {
                editor = new RichTextAttributeEditor(this.model, this.taskRepository, taskAttribute);
            }
            if (this.editorToolkit != null) {
                editor.setRenderingEngine(this.editorToolkit.getRenderingEngine(taskAttribute));
            }
            return editor;
        }
        if ("longText".equals(type)) {
            return new LongTextAttributeEditor(this.model, taskAttribute);
        }
        if ("multiSelect".equals(type)) {
            return new MultiSelectionAttributeEditor(this.model, taskAttribute);
        }
        if ("shortRichText".equals(type)) {
            return new RichTextAttributeEditor(this.model, this.taskRepository, taskAttribute, 4);
        }
        if ("shortText".equals(type)) {
            return new TextAttributeEditor(this.model, taskAttribute);
        }
        if ("singleSelect".equals(type)) {
            return new SingleSelectionAttributeEditor(this.model, taskAttribute);
        }
        if ("taskDepenedency".equals(type)) {
            RichTextAttributeEditor editor = new RichTextAttributeEditor(this.model, this.taskRepository, taskAttribute, 18){

                public String getValue() {
                    return this.getAttributeMapper().getValueLabel(this.getTaskAttribute());
                }
            };
            editor.setMode(RepositoryTextViewerConfiguration.Mode.TASK_RELATION);
            editor.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.SINGLE){

                public int getPriority() {
                    return 11;
                }
            });
            return editor;
        }
        if ("url".equals(type)) {
            RichTextAttributeEditor editor = new RichTextAttributeEditor(this.model, this.taskRepository, taskAttribute, 4);
            editor.setMode(RepositoryTextViewerConfiguration.Mode.URL);
            return editor;
        }
        if ("double".equals(type)) {
            return new DoubleAttributeEditor(this.model, taskAttribute);
        }
        if ("integer".equals(type)) {
            return new DoubleAttributeEditor(this.model, taskAttribute);
        }
        throw new IllegalArgumentException("Unsupported editor type: \"" + type + "\"");
    }
}

