/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.trac.tests.support.TracFixture;
import org.eclipse.mylyn.trac.tests.support.TracTestUtil;
import org.eclipse.mylyn.trac.tests.support.XmlRpcServer;

public class TracAttachmentHandlerTest
extends TestCase {
    private TaskRepository repository;
    private TracRepositoryConnector connector;
    private AbstractTaskAttachmentHandler attachmentHandler;
    private XmlRpcServer.TestData data;

    protected void setUp() throws Exception {
        super.setUp();
        this.data = TracFixture.init010();
        this.connector = (TracRepositoryConnector)TasksUi.getRepositoryConnector((String)"trac");
        this.attachmentHandler = this.connector.getTaskAttachmentHandler();
        this.repository = TracFixture.current().singleRepository(this.connector);
    }

    public void testDownloadAttachment() throws Exception {
        ITask task = TracTestUtil.createTask(this.repository, String.valueOf(this.data.attachmentTicketId));
        List<ITaskAttachment> attachments = TracTestUtil.getTaskAttachments(task);
        TracAttachmentHandlerTest.assertTrue((attachments.size() > 0 ? 1 : 0) != 0);
        InputStream in = this.attachmentHandler.getContent(this.repository, task, attachments.get(0).getTaskAttribute(), null);
        try {
            byte[] result = new byte[6];
            in.read(result);
            TracAttachmentHandlerTest.assertEquals((String)"Mylar\n", (String)new String(result));
            TracAttachmentHandlerTest.assertEquals((int)-1, (int)in.read());
        }
        finally {
            in.close();
        }
    }

    public void testGetAttachmentData() throws Exception {
        ITask task = TracTestUtil.createTask(this.repository, String.valueOf(this.data.attachmentTicketId));
        List<ITaskAttachment> attachments = TracTestUtil.getTaskAttachments(task);
        TracAttachmentHandlerTest.assertTrue((attachments.size() > 0 ? 1 : 0) != 0);
        InputStream in = this.attachmentHandler.getContent(this.repository, task, attachments.get(0).getTaskAttribute(), null);
        byte[] result = new byte[6];
        try {
            in.read(result);
        }
        finally {
            in.close();
        }
        TracAttachmentHandlerTest.assertEquals((String)"Mylar\n", (String)new String(result));
    }

    public void testUploadAttachment() throws Exception {
        ITask task = TracTestUtil.createTask(this.repository, String.valueOf(this.data.attachmentTicketId));
        File file = File.createTempFile("attachment", null);
        file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(file);
        try {
            ((OutputStream)out).write("Mylar".getBytes());
        }
        finally {
            ((OutputStream)out).close();
        }
        this.attachmentHandler.postContent(this.repository, task, (AbstractTaskAttachmentSource)new FileTaskAttachmentSource(file), "comment", null, null);
        ITracClient client = this.connector.getClientManager().getTracClient(this.repository);
        InputStream in = client.getAttachmentData(this.data.attachmentTicketId, file.getName(), null);
        try {
            byte[] result = new byte[5];
            in.read(result);
            TracAttachmentHandlerTest.assertEquals((String)"Mylar", (String)new String(result));
        }
        finally {
            in.close();
        }
    }

    public void testCanUploadAttachmentXmlRpc() throws Exception {
        this.repository = TracFixture.TRAC_0_10_XML_RPC.singleRepository();
        ITask task = TracTestUtil.createTask(this.repository, String.valueOf(this.data.attachmentTicketId));
        TracAttachmentHandlerTest.assertTrue((boolean)this.attachmentHandler.canPostContent(this.repository, task));
    }

    public void testCanUploadAttachmentWeb() throws Exception {
        this.repository = TracFixture.TRAC_0_10_WEB.singleRepository();
        ITask task = TracTestUtil.createTask(this.repository, String.valueOf(this.data.attachmentTicketId));
        TracAttachmentHandlerTest.assertFalse((boolean)this.attachmentHandler.canPostContent(this.repository, task));
    }

    public void testCanDownloadAttachmentXmlRpc() throws Exception {
        this.repository = TracFixture.TRAC_0_10_XML_RPC.singleRepository();
        ITask task = TracTestUtil.createTask(this.repository, String.valueOf(this.data.attachmentTicketId));
        TracAttachmentHandlerTest.assertTrue((boolean)this.attachmentHandler.canGetContent(this.repository, task));
    }

    public void testCanDownloadAttachmentWeb() throws Exception {
        this.repository = TracFixture.TRAC_0_10_WEB.singleRepository();
        ITask task = TracTestUtil.createTask(this.repository, String.valueOf(this.data.attachmentTicketId));
        TracAttachmentHandlerTest.assertFalse((boolean)this.attachmentHandler.canGetContent(this.repository, task));
    }
}

