/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizationSession;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.trac.tests.support.TracFixture;
import org.eclipse.mylyn.trac.tests.support.TracTestUtil;
import org.eclipse.mylyn.trac.tests.support.XmlRpcServer;

public class TracRepositoryConnectorWebTest
extends TestCase {
    private TracRepositoryConnector connector;
    private TaskRepository repository;
    private XmlRpcServer.TestData data;

    protected void setUp() throws Exception {
        super.setUp();
        this.data = TracFixture.init010();
        this.connector = (TracRepositoryConnector)TasksUi.getRepositoryConnector((String)"trac");
        this.repository = TracFixture.current(TracFixture.TRAC_0_10_WEB).singleRepository(this.connector);
    }

    private SynchronizationSession createSession(ITask ... tasks) {
        SynchronizationSession session = new SynchronizationSession();
        session.setNeedsPerformQueries(true);
        session.setTaskRepository(this.repository);
        session.setFullSynchronization(true);
        session.setTasks(new HashSet<ITask>(Arrays.asList(tasks)));
        return session;
    }

    public void testPreSynchronizationWeb096() throws Exception {
        ITask task = TracTestUtil.createTask(this.repository, String.valueOf(this.data.offlineHandlerTicketId));
        HashSet<ITask> tasks = new HashSet<ITask>();
        tasks.add(task);
        SynchronizationSession session = this.createSession(new ITask[0]);
        session.setTasks(tasks);
        TracRepositoryConnectorWebTest.assertEquals(null, (String)this.repository.getSynchronizationTimeStamp());
        this.connector.preSynchronization((ISynchronizationSession)session, null);
        TracRepositoryConnectorWebTest.assertTrue((boolean)session.needsPerformQueries());
        TracRepositoryConnectorWebTest.assertEquals(null, (String)this.repository.getSynchronizationTimeStamp());
        TracRepositoryConnectorWebTest.assertEquals(Collections.emptySet(), (Object)session.getStaleTasks());
        int time = (int)(System.currentTimeMillis() / 1000L) + 1;
        this.repository.setSynchronizationTimeStamp(String.valueOf(time));
        this.connector.preSynchronization((ISynchronizationSession)session, null);
        TracRepositoryConnectorWebTest.assertTrue((boolean)session.needsPerformQueries());
        TracRepositoryConnectorWebTest.assertEquals(Collections.emptySet(), (Object)session.getStaleTasks());
    }
}

