/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.support;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class TestProxy
implements Runnable {
    public static final String NOT_FOUND = "HTTP/1.1 404 Not Found";
    private int listenPort;
    private Message request;
    private Message response;
    private Thread runner;
    private IOException exception;
    private volatile boolean stopped = false;

    public TestProxy(int listenPort) {
        this.listenPort = listenPort;
    }

    public TestProxy() {
    }

    public synchronized int getListenPort() throws InterruptedException {
        while (this.listenPort == 0) {
            this.wait();
        }
        return this.listenPort;
    }

    public void start() {
        this.runner = new Thread((Runnable)this, "TestProxy :" + this.listenPort);
        this.runner.start();
    }

    public int startAndWait() throws InterruptedException {
        this.start();
        int port = this.getListenPort();
        Thread.sleep(100L);
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block32: {
            serverSocket = null;
            try {
                serverSocket = new ServerSocket(this.listenPort);
                var2_2 = this;
                synchronized (var2_2) {
                    this.listenPort = serverSocket.getLocalPort();
                    this.notifyAll();
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 13] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (true) ** GOTO lbl32
                }
                do {
                    socket = serverSocket.accept();
                    try {
                        request = this.readMessage(socket.getInputStream());
                        this.setRequest(request);
                        response = this.waitForResponse();
                        this.writeMessage(response, socket.getOutputStream());
                    }
                    catch (Throwable var5_6) {
                        try {
                            socket.close();
                        }
                        catch (IOException v1) {}
                        throw var5_6;
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException v2) {}
lbl32:
                    // 3 sources

                } while (!this.stopped);
            }
            catch (InterruptedIOException v3) {
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException v4) {}
                }
                break block32;
            }
            catch (IOException e) {
                this.setException(e);
                ** if (serverSocket == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException v5) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block32;
                }
            }
            catch (InterruptedException v6) {
                ** if (serverSocket == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException v7) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block32;
                }
                {
                    catch (Throwable var6_7) {
                        if (serverSocket != null) {
                            try {
                                serverSocket.close();
                            }
                            catch (IOException v8) {}
                        }
                        throw var6_7;
                    }
                }
            }
            if (serverSocket == null) break block32;
            try {
                serverSocket.close();
            }
            catch (IOException v9) {}
        }
    }

    private void writeMessage(Message message, OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        writer.write(message.toString());
    }

    private synchronized void setException(IOException exception) {
        this.exception = exception;
        this.notifyAll();
    }

    public synchronized void checkForException() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private Message readMessage(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        Message message = null;
        while ((line = reader.readLine()) != null) {
            if (line.length() == 0) {
                if (message == null) {
                    throw new IOException("Incomplete message");
                }
                return message;
            }
            if (message == null) {
                message = new Message(line);
                continue;
            }
            StringTokenizer t = new StringTokenizer(line, ":");
            message.headers.put(t.nextToken(), t.nextToken().trim());
        }
        throw new EOFException();
    }

    public void stop() {
        this.stopped = true;
        this.runner.interrupt();
        try {
            this.runner.join(500L);
        }
        catch (InterruptedException interruptedException) {}
    }

    public Message getRequest() {
        return this.request;
    }

    public synchronized Message waitForRequest() throws InterruptedException {
        while (this.request == null) {
            this.wait();
        }
        return this.request;
    }

    public synchronized Message waitForResponse() throws InterruptedException {
        while (this.response == null) {
            this.wait();
        }
        return this.response;
    }

    public synchronized void setResponse(Message response) {
        this.response = response;
        this.notifyAll();
    }

    public synchronized void setResponse(String response) {
        this.response = new Message(response);
        this.notifyAll();
    }

    public synchronized void setRequest(Message request) {
        this.request = request;
        this.notifyAll();
    }

    public static void main(String[] args) {
        TestProxy proxy = new TestProxy(8080);
        proxy.start();
        try {
            proxy.setResponse(new Message("404 / HTTP 1.1"));
            try {
                System.out.println(proxy.waitForRequest());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        finally {
            proxy.stop();
        }
    }

    public static class Message {
        public String request;
        public Map<String, String> headers = new HashMap<String, String>();

        public Message(String request) {
            this.request = request;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.request);
            sb.append("\n");
            if (this.headers != null) {
                for (String key : this.headers.keySet()) {
                    sb.append(String.valueOf(key) + ": " + this.headers.get(key));
                    sb.append("\n");
                }
            }
            sb.append("\n");
            return sb.toString();
        }

        public String getMethod() {
            int i = this.request.indexOf(" ");
            return i != -1 ? this.request.substring(0, i) : this.request;
        }
    }
}

