/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.builds.core.spi.BuildConnector;
import org.eclipse.mylyn.builds.ui.spi.BuildConnectorUi;
import org.eclipse.mylyn.internal.builds.ui.BuildConnectorDelegate;
import org.eclipse.mylyn.internal.builds.ui.BuildConnectorUiDelegate;
import org.eclipse.osgi.util.NLS;

public class BuildConnectorDescriptor {
    final String connectorKind;
    BuildConnector core;
    private BuildConnectorDelegate coreDelegate;
    private final IConfigurationElement element;
    final String label;
    private IStatus status;
    BuildConnectorUi ui;
    private BuildConnectorUiDelegate uiDelegate;

    public BuildConnectorDescriptor(IConfigurationElement element) {
        this.element = element;
        this.connectorKind = element.getAttribute("kind");
        this.label = element.getAttribute("label");
    }

    public IStatus createCore() {
        try {
            Object object = this.element.createExecutableExtension("core");
            if (object instanceof BuildConnector) {
                this.core = (BuildConnector)object;
                this.core.init(this.connectorKind, this.label);
                return Status.OK_STATUS;
            }
            return new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)"Connector core ''{0}'' does not extend expected class for extension contributed by {1}", (Object)object.getClass().getCanonicalName(), (Object)this.getPluginId()));
        }
        catch (Throwable e) {
            return new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)"Connector core failed to load for extension contributed by {0}", (Object)this.getPluginId()), e);
        }
    }

    public IStatus createUi() {
        IStatus result;
        if (this.core == null && !(result = this.createCore()).isOK()) {
            return result;
        }
        try {
            Object object = this.element.createExecutableExtension("ui");
            if (object instanceof BuildConnectorUi) {
                this.ui = (BuildConnectorUi)object;
                this.ui.init(this.core, this.getElement());
                return Status.OK_STATUS;
            }
            return new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)"Connector ui ''{0}'' does not extend expected class for extension contributed by {1}", (Object)object.getClass().getCanonicalName(), (Object)this.getPluginId()));
        }
        catch (Throwable e) {
            return new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)"Connector ui failed to load for extension contributed by {0}", (Object)this.getPluginId()), e);
        }
    }

    public String getConnectorKind() {
        return this.connectorKind;
    }

    public BuildConnectorDelegate getCoreDelegate() {
        if (this.coreDelegate == null) {
            this.coreDelegate = new BuildConnectorDelegate(this);
        }
        return this.coreDelegate;
    }

    public IConfigurationElement getElement() {
        return this.element;
    }

    public String getPluginId() {
        return this.element.getContributor().getName();
    }

    public BuildConnectorUiDelegate getUiDelegate() {
        if (this.uiDelegate == null) {
            this.uiDelegate = new BuildConnectorUiDelegate(this, this.getCoreDelegate());
        }
        return this.uiDelegate;
    }

    public IStatus validate() {
        if (this.connectorKind == null) {
            return new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)"Connector core extension contributed by {0} does not specify kind attribute", (Object)this.getPluginId()));
        }
        if (this.label == null) {
            return new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)"Connector core extension contributed by {0} does not specify label attribute", (Object)this.getPluginId()));
        }
        if (this.element.getAttribute("core") == null) {
            return new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)"Connector core extension contributed by {0} does not specify core attribute", (Object)this.getPluginId()));
        }
        return Status.OK_STATUS;
    }
}

