/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.view;

import java.io.File;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.builds.core.BuildStatus;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.internal.core.BuildModel;
import org.eclipse.mylyn.builds.internal.core.util.BuildsConstants;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.TreeSorter;
import org.eclipse.mylyn.commons.ui.TreeViewerSupport;
import org.eclipse.mylyn.commons.ui.actions.CollapseAllAction;
import org.eclipse.mylyn.commons.ui.actions.ExpandAllAction;
import org.eclipse.mylyn.internal.builds.ui.BuildImages;
import org.eclipse.mylyn.internal.builds.ui.BuildToolTip;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiPlugin;
import org.eclipse.mylyn.internal.builds.ui.actions.RunBuildAction;
import org.eclipse.mylyn.internal.builds.ui.actions.ShowBuildOutputAction;
import org.eclipse.mylyn.internal.builds.ui.actions.ShowTestResultsAction;
import org.eclipse.mylyn.internal.builds.ui.commands.OpenHandler;
import org.eclipse.mylyn.internal.builds.ui.notifications.BuildsServiceMessageControl;
import org.eclipse.mylyn.internal.builds.ui.view.BuildContentProvider;
import org.eclipse.mylyn.internal.builds.ui.view.BuildElementPropertiesAction;
import org.eclipse.mylyn.internal.builds.ui.view.BuildLabelProvider;
import org.eclipse.mylyn.internal.builds.ui.view.BuildModelContentAdapter;
import org.eclipse.mylyn.internal.builds.ui.view.BuildStatusFilter;
import org.eclipse.mylyn.internal.builds.ui.view.BuildSummaryLabelProvider;
import org.eclipse.mylyn.internal.builds.ui.view.FilterByStatusAction;
import org.eclipse.mylyn.internal.builds.ui.view.NewBuildServerAction;
import org.eclipse.mylyn.internal.builds.ui.view.NewBuildServerMenuAction;
import org.eclipse.mylyn.internal.builds.ui.view.NotificationSinkProxy;
import org.eclipse.mylyn.internal.builds.ui.view.OpenBuildsPreferencesAction;
import org.eclipse.mylyn.internal.builds.ui.view.OpenWithBrowserAction;
import org.eclipse.mylyn.internal.builds.ui.view.PresentationMenuAction;
import org.eclipse.mylyn.internal.builds.ui.view.RefreshAction;
import org.eclipse.mylyn.internal.builds.ui.view.RefreshAutomaticallyAction;
import org.eclipse.mylyn.internal.builds.ui.view.RelativeBuildTimeLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.osgi.framework.Bundle;

public class BuildsView
extends ViewPart
implements IShowInTarget {
    private BuildStatusFilter buildStatusFilter;
    private Action collapseAllAction;
    private BuildContentProvider contentProvider;
    private Action expandAllAction;
    private FilterByStatusAction filterDisabledAction;
    private Date lastRefresh;
    private Composite messageComposite;
    private BuildModel model;
    private AdapterImpl modelListener;
    private BuildElementPropertiesAction propertiesAction;
    private final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("refresh.enabled".equals(event.getProperty())) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (BuildsView.this.refreshAutomaticallyAction != null) {
                            BuildsView.this.refreshAutomaticallyAction.updateState();
                        }
                    }
                });
            }
        }
    };
    private RefreshAutomaticallyAction refreshAutomaticallyAction;
    private StackLayout stackLayout;
    private IMemento stateMemento;
    private TreeViewer viewer;
    private PresentationMenuAction presentationsMenuAction;
    private BuildToolTip toolTip;
    private BuildsServiceMessageControl serviceMessageControl;
    private TreeViewerSupport treeViewerSupport;

    public static BuildsView openInActivePerspective() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                return (BuildsView)page.showView("org.eclipse.mylyn.builds.navigator.builds");
            }
            catch (PartInitException partInitException) {}
        }
        return null;
    }

    public BuildsView() {
        BuildsUiPlugin.getDefault().initializeRefresh();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void createMessage(Composite parent) {
        this.messageComposite = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.messageComposite.setLayout((Layout)layout);
        this.messageComposite.setBackground(parent.getDisplay().getSystemColor(25));
        Link link = new Link(this.messageComposite, 64);
        link.setBackground(parent.getDisplay().getSystemColor(25));
        link.setText("No build servers available. Create a <a href=\"create\">build server</a>...");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if ("create".equals(event.text)) {
                    new NewBuildServerAction().run();
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        Composite body = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 1;
        body.setLayout((Layout)layout);
        Composite composite = new Composite(body, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.stackLayout = new StackLayout();
        composite.setLayout((Layout)this.stackLayout);
        composite.setBackground(parent.getDisplay().getSystemColor(25));
        this.createMessage(composite);
        this.createViewer(composite);
        this.initActions();
        this.createPopupMenu(body);
        this.contributeToActionBars();
        this.toolTip = new BuildToolTip(this.getViewer().getControl());
        this.toolTip.setViewer((ColumnViewer)this.viewer);
        this.viewer.getTree().setToolTipText("");
        IWorkbenchSiteProgressService progress = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (progress != null) {
            progress.showBusyForFamily(BuildsConstants.JOB_FAMILY);
        }
        this.model = BuildsUiInternal.getModel();
        this.modelListener = new BuildModelContentAdapter(){

            public void doNotifyChanged(Notification msg) {
                if (!BuildsView.this.viewer.getControl().isDisposed()) {
                    BuildsView.this.lastRefresh = new Date();
                    BuildsView.this.updateContents(Status.OK_STATUS);
                }
            }
        };
        this.model.eAdapters().add((Object)this.modelListener);
        if (this.stateMemento != null) {
            this.restoreState(this.stateMemento);
            this.stateMemento = null;
        }
        this.serviceMessageControl = new BuildsServiceMessageControl(body);
        this.viewer.setInput((Object)this.model);
        this.viewer.setSorter((ViewerSorter)new BuildTreeSorter());
        this.viewer.expandAll();
        this.installAutomaticResize(this.viewer.getTree());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.propertiesAction);
        this.propertiesAction.selectionChanged((IStructuredSelection)this.getSite().getSelectionProvider().getSelection());
        this.updateContents(Status.OK_STATUS);
        this.treeViewerSupport = new TreeViewerSupport(this.viewer, this.getStateFile());
        NotificationSinkProxy.setControl(this.serviceMessageControl);
    }

    private void installAutomaticResize(final Tree tree) {
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                BuildsView.this.packColumnsAsync(tree);
            }
        };
        tree.addListener(18, listener);
        tree.addListener(17, listener);
        tree.getParent().addListener(11, listener);
    }

    void packColumnsAsync(final Tree tree) {
        tree.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!tree.isDisposed()) {
                    try {
                        tree.setRedraw(false);
                        BuildsView.this.packColumns(tree);
                    }
                    finally {
                        tree.setRedraw(true);
                    }
                }
            }
        });
    }

    private File getStateFile() {
        IPath stateLocation = Platform.getStateLocation((Bundle)BuildsUiPlugin.getDefault().getBundle());
        return stateLocation.append("BuildView.xml").toFile();
    }

    protected void createPopupMenu(Composite parent) {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new GroupMarker("group.open"));
        menuManager.add((IContributionItem)new Separator("group.edit"));
        menuManager.add((IContributionItem)new Separator("group.file"));
        menuManager.add((IContributionItem)new Separator("group.run"));
        menuManager.add((IContributionItem)new Separator("group.refresh"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("group.properties"));
        Menu contextMenu = menuManager.createContextMenu((Control)parent);
        this.viewer.getTree().setMenu(contextMenu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    protected void createViewer(Composite parent) {
        this.viewer = new TreeViewer(parent, 65536);
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        TreeViewerColumn buildViewerColumn = new TreeViewerColumn(this.viewer, 16384);
        buildViewerColumn.setLabelProvider((CellLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new BuildLabelProvider(true), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null));
        TreeColumn buildColumn = buildViewerColumn.getColumn();
        buildColumn.setText("Build");
        buildColumn.setWidth(220);
        buildColumn.setData("org.eclipse.mylyn.column.viewer.support.column.can.hide", (Object)false);
        TreeViewerColumn summaryViewerColumn = new TreeViewerColumn(this.viewer, 16384);
        summaryViewerColumn.setLabelProvider((CellLabelProvider)new BuildSummaryLabelProvider());
        TreeColumn summaryColumn = summaryViewerColumn.getColumn();
        summaryColumn.setText("Summary");
        summaryColumn.setWidth(220);
        TreeViewerColumn lastBuiltViewerColumn = new TreeViewerColumn(this.viewer, 131072);
        lastBuiltViewerColumn.setLabelProvider((CellLabelProvider)new RelativeBuildTimeLabelProvider());
        TreeColumn lastBuiltColumn = lastBuiltViewerColumn.getColumn();
        lastBuiltColumn.setText("Last Built");
        lastBuiltColumn.setWidth(50);
        this.contentProvider = new BuildContentProvider();
        this.contentProvider.setSelectedOnly(true);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element instanceof IBuildElement) {
                    OpenHandler.open(BuildsView.this.getSite().getPage(), Collections.singletonList((IBuildElement)element));
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.model.eAdapters().remove((Object)this.modelListener);
        BuildsUiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.presentationsMenuAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.collapseAllAction);
        manager.add((IAction)this.expandAllAction);
        manager.add((IContributionItem)new Separator("group.filter"));
        manager.add((IAction)this.filterDisabledAction);
        manager.add((IContributionItem)new Separator("group.navigate"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("group.properties"));
        manager.add((IAction)this.refreshAutomaticallyAction);
        manager.add((IContributionItem)new Separator("group.preferences"));
        manager.add((IAction)new OpenBuildsPreferencesAction());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)new NewBuildServerMenuAction());
        manager.add((IContributionItem)new Separator("group.refresh"));
        RefreshAction refresh = new RefreshAction();
        manager.add((IAction)refresh);
        manager.add((IContributionItem)new Separator("group.open"));
        OpenWithBrowserAction openInBrowserAction = new OpenWithBrowserAction();
        openInBrowserAction.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)openInBrowserAction);
        manager.add((IAction)openInBrowserAction);
        RunBuildAction runBuildAction = new RunBuildAction();
        runBuildAction.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)runBuildAction);
        manager.add((IAction)runBuildAction);
        manager.add((IContributionItem)new Separator("group.file"));
        ShowBuildOutputAction openConsoleAction = new ShowBuildOutputAction();
        openConsoleAction.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)openConsoleAction);
        manager.add((IAction)openConsoleAction);
        ShowTestResultsAction showTestResultsAction = new ShowTestResultsAction();
        showTestResultsAction.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)showTestResultsAction);
        manager.add((IAction)showTestResultsAction);
    }

    public BuildStatusFilter getBuildStatusFilter() {
        if (this.buildStatusFilter == null) {
            this.buildStatusFilter = new BuildStatusFilter();
            this.getViewer().addFilter((ViewerFilter)this.buildStatusFilter);
        }
        return this.buildStatusFilter;
    }

    public BuildContentProvider getContentProvider() {
        return this.contentProvider;
    }

    protected BuildStatus getPlanStatus() {
        BuildStatus planStatus = null;
        boolean plansSelected = false;
        if (this.contentProvider != null) {
            for (IBuildPlan plan : this.model.getPlans()) {
                if (plan.getStatus() != null) {
                    switch (plan.getStatus()) {
                        case SUCCESS: {
                            if (planStatus != null) break;
                            planStatus = BuildStatus.SUCCESS;
                            break;
                        }
                        case UNSTABLE: {
                            if (planStatus != null && planStatus != BuildStatus.SUCCESS) break;
                            planStatus = BuildStatus.UNSTABLE;
                            break;
                        }
                        case FAILED: {
                            planStatus = BuildStatus.FAILED;
                        }
                    }
                }
                plansSelected = true;
            }
        }
        if (plansSelected) {
            return planStatus != null ? planStatus : BuildStatus.DISABLED;
        }
        return null;
    }

    TreeViewer getViewer() {
        return this.viewer;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        BuildsUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        this.stateMemento = memento;
    }

    private void initActions() {
        this.collapseAllAction = new CollapseAllAction((AbstractTreeViewer)this.viewer);
        this.expandAllAction = new ExpandAllAction((AbstractTreeViewer)this.viewer);
        this.propertiesAction = new BuildElementPropertiesAction();
        this.refreshAutomaticallyAction = new RefreshAutomaticallyAction();
        this.filterDisabledAction = new FilterByStatusAction(this, BuildStatus.DISABLED);
        this.presentationsMenuAction = new PresentationMenuAction(this);
    }

    private void restoreState(IMemento memento) {
        String id;
        IMemento child = memento.getChild("statusFilter");
        if (child != null) {
            boolean changed = false;
            BuildStatus[] buildStatusArray = BuildStatus.values();
            int n = buildStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                BuildStatus status = buildStatusArray[n2];
                Boolean value = child.getBoolean(status.name());
                if (value != null && value.booleanValue()) {
                    this.getBuildStatusFilter().addFiltered(status);
                    changed = true;
                }
                ++n2;
            }
            if (changed) {
                this.filterDisabledAction.update();
            }
        }
        if ((child = memento.getChild("presentation")) != null && (id = child.getString("id")) != null) {
            try {
                this.getContentProvider().setPresentation(BuildContentProvider.Presentation.valueOf(id));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void saveState(IMemento memento) {
        Set<BuildStatus> statuses;
        super.saveState(memento);
        if (this.buildStatusFilter != null && (statuses = this.buildStatusFilter.getFiltered()).size() > 0) {
            IMemento child = memento.createChild("statusFilter");
            for (BuildStatus status : statuses) {
                child.putBoolean(status.name(), true);
            }
        }
        IMemento child = memento.createChild("presentation");
        child.putString("id", this.getContentProvider().getPresentation().name());
    }

    public void setFocus() {
        this.getViewer().getControl().setFocus();
    }

    private void setTopControl(Control control) {
        if (this.stackLayout.topControl != control) {
            this.stackLayout.topControl = control;
            control.getParent().layout();
        }
    }

    public boolean show(ShowInContext context) {
        if (context.getSelection() != null) {
            this.getViewer().setSelection(context.getSelection());
            return true;
        }
        return false;
    }

    private void updateContents(IStatus status) {
        boolean isShowingViewer = this.stackLayout.topControl == this.viewer.getControl();
        boolean hasContents = false;
        if (this.contentProvider != null && (this.model.getPlans().size() > 0 || this.model.getServers().size() > 0)) {
            hasContents = true;
        }
        if (hasContents) {
            this.setTopControl(this.viewer.getControl());
            if (!isShowingViewer) {
                this.packColumnsAsync(this.viewer.getTree());
            }
        } else {
            this.setTopControl((Control)this.messageComposite);
        }
        this.updateDecoration(status);
    }

    public void updateDecoration(IStatus status) {
        IStatusLineManager statusLine;
        IViewSite viewSite;
        String statusMessage = "";
        if (status.isOK()) {
            BuildStatus planStatus = this.getPlanStatus();
            if (planStatus == BuildStatus.SUCCESS) {
                this.setTitleImage(CommonImages.getImageWithOverlay((ImageDescriptor)BuildImages.VIEW_BUILDS, (ImageDescriptor)CommonImages.OVERLAY_SUCCESS, (boolean)false, (boolean)false));
            } else if (planStatus == BuildStatus.UNSTABLE) {
                this.setTitleImage(CommonImages.getImageWithOverlay((ImageDescriptor)BuildImages.VIEW_BUILDS, (ImageDescriptor)CommonImages.OVERLAY_FAILED, (boolean)false, (boolean)false));
            } else if (planStatus == BuildStatus.FAILED) {
                this.setTitleImage(CommonImages.getImageWithOverlay((ImageDescriptor)BuildImages.VIEW_BUILDS, (ImageDescriptor)CommonImages.OVERLAY_ERROR, (boolean)false, (boolean)false));
            } else {
                this.setTitleImage(CommonImages.getImage((ImageDescriptor)BuildImages.VIEW_BUILDS));
            }
            if (this.lastRefresh != null) {
                statusMessage = NLS.bind((String)"Last update: {0}", (Object)DateFormat.getDateTimeInstance().format(this.lastRefresh));
            }
        } else {
            this.setTitleImage(CommonImages.getImageWithOverlay((ImageDescriptor)BuildImages.VIEW_BUILDS, (ImageDescriptor)CommonImages.OVERLAY_WARNING, (boolean)false, (boolean)false));
            statusMessage = "Last update failed";
        }
        if (statusMessage != null && (viewSite = this.getViewSite()) != null && (statusLine = viewSite.getActionBars().getStatusLineManager()) != null) {
            statusLine.setMessage(statusMessage);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.team.ui.GenericHistoryView"};
                }
            };
        }
        if (adapter == IShowInSource.class) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    return new ShowInContext(BuildsView.this.getViewer().getInput(), BuildsView.this.getViewer().getSelection());
                }
            };
        }
        return super.getAdapter(adapter);
    }

    private void packColumns(Tree tree) {
        int totalColumnWidth = 0;
        TreeColumn[] treeColumnArray = tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn tc = treeColumnArray[n2];
            if (tc.getResizable()) {
                tc.pack();
                totalColumnWidth += tc.getWidth() + 1;
            } else {
                ++totalColumnWidth;
            }
            ++n2;
        }
        TreeColumn column = tree.getColumn(1).getResizable() ? tree.getColumn(1) : tree.getColumn(0);
        int nw = column.getWidth() + tree.getClientArea().width - totalColumnWidth;
        column.setWidth(nw);
    }

    private class BuildTreeSorter
    extends TreeSorter {
        private BuildTreeSorter() {
        }

        public int compare(TreeViewer viewer, Object e1, Object e2, int columnIndex) {
            if (e1 instanceof IBuildServer && e2 instanceof IBuildServer) {
                int res = this.getComparator().compare(((IBuildElement)e1).getLabel(), ((IBuildElement)e2).getLabel());
                if (this.getSortDirection(viewer) == 128) {
                    return -res;
                }
                return res;
            }
            if (e1 instanceof IBuildPlan && e2 instanceof IBuildPlan) {
                IBuildPlan p1 = (IBuildPlan)e1;
                IBuildPlan p2 = (IBuildPlan)e2;
                switch (columnIndex) {
                    case -1: {
                        return CoreUtil.compare((Comparable)((Object)p1.getLabel()), (Object)p2.getLabel());
                    }
                    case 0: {
                        return CoreUtil.compare((Comparable)p1.getStatus(), (Object)p2.getStatus());
                    }
                    case 1: {
                        return p1.getHealth() - p2.getHealth();
                    }
                    case 2: {
                        Long t1 = p1.getLastBuild() != null ? Long.valueOf(p1.getLastBuild().getTimestamp()) : null;
                        Long t2 = p2.getLastBuild() != null ? Long.valueOf(p2.getLastBuild().getTimestamp()) : null;
                        return CoreUtil.compare((Comparable)t1, (Object)t2);
                    }
                }
            }
            return super.compare((ColumnViewer)viewer, e1, e2, columnIndex);
        }

        protected int compareDefault(TreeViewer viewer, Object e1, Object e2) {
            return this.compare(viewer, e1, e2, -1);
        }
    }
}

