/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tests.util;

import java.net.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.IProxyProvider;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestFixture {
    protected AbstractRepositoryConnector connector;
    private final String connectorKind;
    private String repositoryName;
    protected final String repositoryUrl;
    private String simpleInfo;
    private String description;
    private TestSuite suite;

    public static void resetTaskList() throws Exception {
        TasksUi.getTaskActivityManager().deactivateActiveTask();
        TasksUiPlugin.getTaskListExternalizationParticipant().resetTaskList();
        TasksUiPlugin.getTaskActivityManager().getTaskActivationHistory().clear();
        TaskListView view = TaskListView.getFromActivePerspective();
        if (view != null) {
            view.refresh();
        }
    }

    public static void resetTaskListAndRepositories() throws Exception {
        TasksUiPlugin.getRepositoryManager().clearRepositories();
        TasksUiPlugin.getDefault().getLocalTaskRepository();
        TestFixture.resetTaskList();
    }

    public static void saveAndReadTasklist() throws Exception {
        TasksUiPlugin.getTaskList().notifyElementsChanged(null);
        TestFixture.saveNow();
        TestFixture.resetTaskList();
        TasksUiPlugin.getDefault().initializeDataSources();
    }

    public static void saveNow() throws Exception {
        TasksUiPlugin.getExternalizationManager().saveNow();
    }

    public TestFixture(String connectorKind, String repositoryUrl) {
        this.connectorKind = connectorKind;
        this.repositoryUrl = repositoryUrl;
    }

    protected abstract TestFixture activate();

    public void add(Class<? extends TestCase> clazz) {
        Assert.isNotNull((Object)this.suite, (String)"Invoke createSuite() first");
        this.suite.addTestSuite(clazz);
    }

    protected void configureRepository(TaskRepository repository) {
    }

    public AbstractRepositoryConnector connector() {
        return this.connector;
    }

    public TestSuite createSuite(TestSuite parentSuite) {
        this.suite = new TestSuite("Testing on " + this.getInfo());
        parentSuite.addTest((Test)this.suite);
        this.suite.addTest((Test)new Activation("repository: " + this.getRepositoryUrl() + " [@" + this.getSimpleInfo() + "]", true));
        return this.suite;
    }

    public void done() {
        Assert.isNotNull((Object)this.suite, (String)"Invoke createSuite() first");
        this.suite.addTest((Test)new Activation("done", false));
        this.suite = null;
    }

    public String getConnectorKind() {
        return this.connectorKind;
    }

    protected abstract TestFixture getDefault();

    public String getInfo() {
        return String.valueOf(this.repositoryName) + " " + this.simpleInfo;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getSimpleInfo() {
        return this.simpleInfo;
    }

    public AbstractWebLocation location() throws Exception {
        return this.location(CommonTestUtil.PrivilegeLevel.USER);
    }

    public AbstractWebLocation location(CommonTestUtil.PrivilegeLevel level) throws Exception {
        return this.location(level, WebUtil.getProxyForUrl((String)this.repositoryUrl));
    }

    public AbstractWebLocation location(CommonTestUtil.PrivilegeLevel level, Proxy proxy) throws Exception {
        UserCredentials credentials = CommonTestUtil.getCredentials((CommonTestUtil.PrivilegeLevel)level);
        return this.location(credentials.getUserName(), credentials.getPassword(), proxy);
    }

    public AbstractWebLocation location(String username, String password) throws Exception {
        return this.location(username, password, WebUtil.getProxyForUrl((String)this.repositoryUrl));
    }

    public AbstractWebLocation location(String username, String password, final Proxy proxy) throws Exception {
        return new WebLocation(this.repositoryUrl, username, password, new IProxyProvider(){

            public Proxy getProxyForHost(String host, String proxyType) {
                return proxy;
            }
        });
    }

    public TaskRepository repository() {
        TaskRepository repository = new TaskRepository(this.connectorKind, this.repositoryUrl);
        UserCredentials credentials = CommonTestUtil.getCredentials((CommonTestUtil.PrivilegeLevel)CommonTestUtil.PrivilegeLevel.USER);
        repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials(credentials.getUserName(), credentials.getPassword()), false);
        return repository;
    }

    protected void resetRepositories() {
    }

    protected void setInfo(String repositoryName, String version, String description) {
        Assert.isNotNull((Object)repositoryName);
        Assert.isNotNull((Object)version);
        this.repositoryName = repositoryName;
        this.simpleInfo = version;
        this.description = description;
        if (description != null && description.length() > 0) {
            this.simpleInfo = String.valueOf(this.simpleInfo) + "/" + description;
        }
    }

    public TaskRepository singleRepository() {
        TaskRepositoryManager manager = TasksUiPlugin.getRepositoryManager();
        if (manager != null) {
            manager.clearRepositories();
        }
        this.resetRepositories();
        TaskRepository repository = new TaskRepository(this.connectorKind, this.repositoryUrl);
        UserCredentials credentials = CommonTestUtil.getCredentials((CommonTestUtil.PrivilegeLevel)CommonTestUtil.PrivilegeLevel.USER);
        repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials(credentials.getUserName(), credentials.getPassword()), true);
        this.configureRepository(repository);
        if (manager != null) {
            manager.addRepository(repository);
        }
        return repository;
    }

    public void setUpFramework() {
        TestFixture.initializeTasksSettings();
    }

    public static void initializeTasksSettings() {
        try {
            TasksUiPlugin plugin = TasksUiPlugin.getDefault();
            if (plugin == null) {
                return;
            }
            IPreferenceStore store = plugin.getPreferenceStore();
            store.setValue("org.eclipse.mylyn.tasks.ui.notifications.enabled", false);
            store.setValue("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule", false);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
    }

    public boolean isExcluded() {
        String excludeFixture = System.getProperty("mylyn.test.exclude", "");
        String[] excludeFixtureArray = excludeFixture.split(",");
        return new HashSet<String>(Arrays.asList(excludeFixtureArray)).contains(this.getRepositoryUrl());
    }

    public String getDescription() {
        return this.description;
    }

    private final class Activation
    extends TestCase {
        private final boolean activate;

        private Activation(String name, boolean activate) {
            super(name);
            this.activate = activate;
        }

        protected void runTest() throws Throwable {
            if (this.activate) {
                TestFixture.this.activate();
            } else {
                TestFixture.this.getDefault().activate();
            }
        }
    }
}

