/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.RefactorRepositoryUrlOperation;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryQuery;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;

public class RefactorRepositoryUrlOperationTest
extends TestCase {
    private TaskList taskList;

    protected void setUp() throws Exception {
        super.setUp();
        this.taskList = TasksUiPlugin.getTaskList();
        TaskTestUtil.resetTaskList();
    }

    public void testMigrateQueryUrlHandles() throws Exception {
        MockRepositoryQuery query = new MockRepositoryQuery("mquery");
        query.setRepositoryUrl("http://foo.bar");
        query.setUrl("http://foo.bar/b");
        this.taskList.addQuery((RepositoryQuery)query);
        RefactorRepositoryUrlOperationTest.assertTrue((this.taskList.getRepositoryQueries("http://foo.bar").size() > 0 ? 1 : 0) != 0);
        new RefactorRepositoryUrlOperation("http://foo.bar", "http://bar.baz").run((IProgressMonitor)new NullProgressMonitor());
        RefactorRepositoryUrlOperationTest.assertTrue((this.taskList.getRepositoryQueries("http://foo.bar").size() == 0 ? 1 : 0) != 0);
        RefactorRepositoryUrlOperationTest.assertTrue((this.taskList.getRepositoryQueries("http://bar.baz").size() > 0 ? 1 : 0) != 0);
        IRepositoryQuery changedQuery = (IRepositoryQuery)this.taskList.getRepositoryQueries("http://bar.baz").iterator().next();
        RefactorRepositoryUrlOperationTest.assertEquals((String)"http://bar.baz/b", (String)changedQuery.getUrl());
    }

    public void testMigrateQueryHandles() throws Exception {
        MockRepositoryQuery query = new MockRepositoryQuery("mquery");
        query.setRepositoryUrl("http://a");
        this.taskList.addQuery((RepositoryQuery)query);
        new RefactorRepositoryUrlOperation("http://a", "http://b").run((IProgressMonitor)new NullProgressMonitor());
        RefactorRepositoryUrlOperationTest.assertFalse((boolean)this.taskList.getRepositoryQueries("http://b").isEmpty());
        RefactorRepositoryUrlOperationTest.assertTrue((boolean)this.taskList.getRepositoryQueries("http://a").isEmpty());
    }

    public void testMigrateTaskHandles() throws Exception {
        MockTask task = new MockTask("http://a", "123");
        MockTask task2 = new MockTask("http://other", "other");
        this.taskList.addTask((ITask)task);
        this.taskList.addTask((ITask)task2);
        TaskRepository repository = new TaskRepository("mock", "http://a");
        TasksUi.getRepositoryManager().addRepository(repository);
        TaskRepository repository2 = new TaskRepository("mock", "http://other");
        TasksUi.getRepositoryManager().addRepository(repository2);
        try {
            TaskData taskData = new TaskData(new TaskAttributeMapper(repository), task.getConnectorKind(), task.getRepositoryUrl(), task.getTaskId());
            TasksUiPlugin.getTaskDataManager().putUpdatedTaskData((ITask)task, taskData, true);
            TaskData taskData2 = new TaskData(new TaskAttributeMapper(repository2), task2.getConnectorKind(), task2.getRepositoryUrl(), task2.getTaskId());
            taskData2.getRoot().createAttribute("comment").setValue("TEST");
            TasksUiPlugin.getTaskDataManager().putUpdatedTaskData((ITask)task2, taskData2, true);
            new RefactorRepositoryUrlOperation("http://a", "http://b").run((IProgressMonitor)new NullProgressMonitor());
            repository.setRepositoryUrl("http://b");
            RefactorRepositoryUrlOperationTest.assertNull((Object)this.taskList.getTask("http://a-123"));
            RefactorRepositoryUrlOperationTest.assertNotNull((Object)this.taskList.getTask("http://b-123"));
            RefactorRepositoryUrlOperationTest.assertNotNull((Object)TasksUi.getTaskDataManager().getTaskData((ITask)task));
            TaskData otherData = TasksUi.getTaskDataManager().getTaskData((ITask)task2);
            RefactorRepositoryUrlOperationTest.assertNotNull((Object)otherData);
            RefactorRepositoryUrlOperationTest.assertEquals((String)"TEST", (String)otherData.getRoot().getAttribute("comment").getValue());
        }
        finally {
            TasksUiPlugin.getTaskDataManager().deleteTaskData((ITask)task);
            TasksUiPlugin.getTaskDataManager().deleteTaskData((ITask)task2);
        }
    }

    public void testMigrateTaskHandlesWithExplicitSet() throws Exception {
        MockTask task = new MockTask("http://aa", "123");
        task.setUrl("http://aa/task/123");
        this.taskList.addTask((ITask)task);
        new RefactorRepositoryUrlOperation("http://aa", "http://bb").run((IProgressMonitor)new NullProgressMonitor());
        RefactorRepositoryUrlOperationTest.assertNull((Object)this.taskList.getTask("http://aa-123"));
        RefactorRepositoryUrlOperationTest.assertNotNull((Object)this.taskList.getTask("http://bb-123"));
        RefactorRepositoryUrlOperationTest.assertEquals((String)"http://bb/task/123", (String)task.getUrl());
    }

    public void testMigrateTaskHandlesUnsubmittedTask() throws Exception {
        ITask task = TasksUiUtil.createOutgoingNewTask((String)"mock", (String)"http://a");
        String handleIdentifier = task.getHandleIdentifier();
        this.taskList.addTask(task);
        RefactorRepositoryUrlOperationTest.assertEquals((String)"http://a", (String)task.getAttribute("outgoingNewRepositoryUrl"));
        TaskRepository repository = new TaskRepository("mock", "http://a");
        TasksUi.getRepositoryManager().addRepository(repository);
        try {
            TaskData taskData = new TaskData(new TaskAttributeMapper(repository), repository.getConnectorKind(), repository.getRepositoryUrl(), "");
            ITaskDataWorkingCopy workingCopy = TasksUi.getTaskDataManager().createWorkingCopy(task, taskData);
            workingCopy.save(null, null);
            new RefactorRepositoryUrlOperation("http://a", "http://b").run((IProgressMonitor)new NullProgressMonitor());
            repository.setRepositoryUrl("http://b");
            RefactorRepositoryUrlOperationTest.assertEquals((Object)task, (Object)this.taskList.getTask(handleIdentifier));
            RefactorRepositoryUrlOperationTest.assertEquals((String)"http://b", (String)task.getAttribute("outgoingNewRepositoryUrl"));
            taskData = TasksUi.getTaskDataManager().getTaskData(task);
            RefactorRepositoryUrlOperationTest.assertNotNull((Object)taskData);
            RefactorRepositoryUrlOperationTest.assertEquals((String)"http://b", (String)taskData.getRepositoryUrl());
        }
        finally {
            TasksUiPlugin.getTaskDataManager().deleteTaskData(task);
        }
    }
}

