/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gitlab.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.http.client.methods.HttpRequestBase;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpOperation;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpResponse;
import org.eclipse.mylyn.commons.repositories.http.core.HttpUtil;
import org.eclipse.mylyn.gitlab.core.GitlabException;
import org.eclipse.mylyn.internal.gitlab.core.GitlabRestClient;
import org.eclipse.osgi.util.NLS;

public abstract class GitlabOperation<T>
extends CommonHttpOperation<T> {
    protected static final String ACCEPT = "Accept";
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String TEXT_XML_CHARSET_UTF_8 = "text/xml; charset=UTF-8";
    private final String urlSuffix;

    public GitlabOperation(CommonHttpClient client, String urlSuffix) {
        super(client);
        this.urlSuffix = urlSuffix;
    }

    public T run(IOperationMonitor monitor) throws GitlabException {
        try {
            return this.execute(monitor);
        }
        catch (IOException e) {
            throw new GitlabException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", "org.eclipse.mylyn.gitlab.core.GitlabOperation.run(IOperationMonitor)", (Throwable)e));
        }
    }

    protected abstract HttpRequestBase createHttpRequestBase(String var1);

    protected abstract T parseFromJson(InputStreamReader var1) throws GitlabException;

    protected HttpRequestBase createHttpRequestBase() {
        HttpRequestBase request = this.createHttpRequestBase(this.createHttpRequestURL());
        return request;
    }

    protected void addHttpRequestEntities(HttpRequestBase request) throws GitlabException {
        request.setHeader(ACCEPT, APPLICATION_JSON);
        String accessToken = (String)this.getClient().getAttribute(GitlabRestClient.AUTHORIZATION_HEADER);
        request.setHeader("Authorization", accessToken);
    }

    protected T doProcess(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, GitlabException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream is = new BufferedInputStream(response.getResponseEntityAsStream());){
            InputStreamReader in = new InputStreamReader(is);
            return this.parseFromJson(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected T processAndRelease(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, GitlabException {
        try {
            this.doValidate(response, monitor);
            T t = this.doProcess(response, monitor);
            return t;
        }
        finally {
            response.release();
        }
    }

    protected void doValidate(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, GitlabException {
        this.validate(response, 200, monitor);
    }

    protected void validate(CommonHttpResponse response, int expected, IOperationMonitor monitor) throws GitlabException {
        int statusCode = response.getStatusCode();
        if (statusCode != expected) {
            if (statusCode == 404) {
                throw new GitlabException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", NLS.bind((String)"Requested resource ''{0}'' does not exist", (Object)response.getRequestPath())));
            }
            throw new GitlabException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", NLS.bind((String)"Unexpected response from Gitlab REST server for ''{0}'': {1}", (Object)response.getRequestPath(), (Object)HttpUtil.getStatusText((int)statusCode))));
        }
    }

    protected String baseUrl() {
        Object url = this.getClient().getLocation().getUrl();
        if (!((String)url).endsWith("/api/v4")) {
            url = (String)url + "/api/v4";
        }
        return url;
    }

    protected T execute(IOperationMonitor monitor) throws IOException, GitlabException {
        HttpRequestBase request = this.createHttpRequestBase();
        this.addHttpRequestEntities(request);
        CommonHttpResponse response = this.execute(request, monitor);
        return this.processAndRelease(response, monitor);
    }

    protected String getUrlSuffix() {
        return this.urlSuffix;
    }

    protected String createHttpRequestURL() {
        String urlSuffix = this.getUrlSuffix();
        return this.baseUrl() + urlSuffix;
    }
}

