/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gitlab.core;

import java.util.Map;
import org.eclipse.mylyn.internal.gitlab.core.GitlabNewTaskSchema;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskSchema;
import org.eclipse.mylyn.tasks.core.data.DefaultTaskSchema;

public class GitlabTaskSchema
extends GitlabNewTaskSchema {
    private final DefaultTaskSchema parent = DefaultTaskSchema.getInstance();
    private static final GitlabTaskSchema instance = new GitlabTaskSchema();
    public final AbstractTaskSchema.Field CREATED;
    public final AbstractTaskSchema.Field UPDATED;
    public final AbstractTaskSchema.Field COMPLETED;
    public final AbstractTaskSchema.Field AUTHOR;
    public final AbstractTaskSchema.Field TASK_KEY;
    public final AbstractTaskSchema.Field URL;
    public final AbstractTaskSchema.Field USER_NOTES_COUNT;
    public final AbstractTaskSchema.Field BLOCKING_ISSUE_COUNT;
    public final AbstractTaskSchema.Field MERGE_REQUEST_COUNT;
    public final AbstractTaskSchema.Field UPVOTES;
    public final AbstractTaskSchema.Field DOWNVOTES;
    public final AbstractTaskSchema.Field HAS_TASKS;
    public final AbstractTaskSchema.Field SUBSCRIBED;
    public final AbstractTaskSchema.Field CONFIDENTIAL;
    public final AbstractTaskSchema.Field NEW_COMMENT;
    public final AbstractTaskSchema.Field DISCUSSION_LOCKED;
    public final AbstractTaskSchema.Field IID;
    public final AbstractTaskSchema.Field OPERATION;
    public final AbstractTaskSchema.Field CLOSED_BY;
    public final AbstractTaskSchema.Field ASSIGNED_TO;
    public final AbstractTaskSchema.Field TYPE;
    public final AbstractTaskSchema.Field TASK_STATUS;
    public final AbstractTaskSchema.Field TASK_LABELS;
    public final AbstractTaskSchema.Field TASK_MILESTONE;
    public final AbstractTaskSchema.Field DUE_DATE;
    private static Map<String, String> json2AttributeMapper = Map.ofEntries(Map.entry("project_id", GitlabTaskSchema.getDefault().PRODUCT.getKey()), Map.entry("description", GitlabTaskSchema.getDefault().DESCRIPTION.getKey()), Map.entry("title", GitlabTaskSchema.getDefault().SUMMARY.getKey()), Map.entry("state", GitlabTaskSchema.getDefault().STATUS.getKey()), Map.entry("assignee", GitlabTaskSchema.getDefault().ASSIGNED_TO.getKey()), Map.entry("author", GitlabTaskSchema.getDefault().AUTHOR.getKey()), Map.entry("id", GitlabTaskSchema.getDefault().TASK_KEY.getKey()), Map.entry("severity", GitlabTaskSchema.getDefault().PRIORITY.getKey()), Map.entry("created_at", GitlabTaskSchema.getDefault().CREATED.getKey()), Map.entry("updated_at", GitlabTaskSchema.getDefault().UPDATED.getKey()), Map.entry("closed_at", GitlabTaskSchema.getDefault().COMPLETED.getKey()), Map.entry("web_url", GitlabTaskSchema.getDefault().URL.getKey()));
    private static Map<String, String> attribute2jsonMapper = Map.ofEntries(Map.entry(GitlabTaskSchema.getDefault().PRODUCT.getKey(), "project_id"), Map.entry(GitlabTaskSchema.getDefault().DESCRIPTION.getKey(), "description"), Map.entry(GitlabTaskSchema.getDefault().SUMMARY.getKey(), "title"), Map.entry(GitlabTaskSchema.getDefault().STATUS.getKey(), "state"), Map.entry(GitlabTaskSchema.getDefault().ASSIGNED_TO.getKey(), "assignee"), Map.entry(GitlabTaskSchema.getDefault().AUTHOR.getKey(), "author"), Map.entry(GitlabTaskSchema.getDefault().TASK_KEY.getKey(), "id"), Map.entry(GitlabTaskSchema.getDefault().PRIORITY.getKey(), "severity"), Map.entry(GitlabTaskSchema.getDefault().CREATED.getKey(), "created_at"), Map.entry(GitlabTaskSchema.getDefault().UPDATED.getKey(), "updated_at"), Map.entry(GitlabTaskSchema.getDefault().COMPLETED.getKey(), "closed_at"), Map.entry(GitlabTaskSchema.getDefault().URL.getKey(), "web_url"));

    public GitlabTaskSchema() {
        this.CREATED = this.inheritFrom(this.parent.DATE_CREATION).create();
        this.UPDATED = this.inheritFrom(this.parent.DATE_MODIFICATION).create();
        this.COMPLETED = this.inheritFrom(this.parent.DATE_COMPLETION).create();
        this.AUTHOR = this.inheritFrom(this.parent.USER_REPORTER).create();
        this.TASK_KEY = this.inheritFrom(this.parent.TASK_KEY).create();
        this.URL = this.inheritFrom(this.parent.TASK_URL).addFlags(new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.ATTRIBUTE}).create();
        this.USER_NOTES_COUNT = this.createField("user_notes_count", "User Notes Count", "integer", new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.ATTRIBUTE});
        this.BLOCKING_ISSUE_COUNT = this.createField("blocking_issues_count", "Blocking Issue Count", "integer", new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.ATTRIBUTE});
        this.MERGE_REQUEST_COUNT = this.createField("merge_requests_count", "Merge Request Count", "integer", new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.ATTRIBUTE});
        this.UPVOTES = this.createField("upvotes", "Up Votes", "integer", new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.ATTRIBUTE});
        this.DOWNVOTES = this.createField("downvotes", "Down Notes", "integer", new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.ATTRIBUTE});
        this.HAS_TASKS = this.createField("has_tasks", "has Tasks", "boolean", new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.ATTRIBUTE});
        this.SUBSCRIBED = this.createField("subscribed", "subscribed", "boolean", new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.ATTRIBUTE});
        this.CONFIDENTIAL = this.createField("confidential", "confidential", "boolean", new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.ATTRIBUTE});
        this.NEW_COMMENT = this.inheritFrom(this.parent.NEW_COMMENT).create();
        this.DISCUSSION_LOCKED = this.createField("discussion_locked", "Discussion locked", "boolean", new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.ATTRIBUTE});
        this.IID = this.createField("iid", "interne ID", "shortText", new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.ATTRIBUTE});
        this.OPERATION = this.createField("task.common.operation", "Operation", "operation");
        this.CLOSED_BY = this.createField("closed_by", "closed by", "person", new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.PEOPLE, AbstractTaskSchema.Flag.READ_ONLY});
        this.ASSIGNED_TO = this.inheritFrom(this.parent.USER_ASSIGNED).label("Assigned to").create();
        this.TYPE = this.createField("type", "Type", "shortText", new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.ATTRIBUTE});
        this.TASK_STATUS = this.createField("task_status", "Task Status", "shortText", new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.ATTRIBUTE});
        this.TASK_LABELS = this.createField("labels", "Labels", "multiSelect", new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.ATTRIBUTE});
        this.TASK_MILESTONE = this.createField("milestone", "Milestone", "singleSelect", new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.ATTRIBUTE});
        this.DUE_DATE = this.createField("due_date", "Due date", "date", new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.ATTRIBUTE});
    }

    public static GitlabTaskSchema getDefault() {
        return instance;
    }

    public static String getAttributeNameFromJsonName(String fieldName) {
        String result = json2AttributeMapper.get(fieldName);
        if (result == null) {
            result = fieldName;
        }
        return result;
    }

    public static String getJsonNameFromAttributeName(String attributeName) {
        String result = attribute2jsonMapper.get(attributeName);
        if (result == null) {
            result = attributeName;
        }
        return result;
    }
}

