/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.blocks;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LinePredicates;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.SourceBlock;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.util.Preconditions;

public class IndentedCodeBlock
extends SourceBlock {
    private static final Pattern PATTERN = Pattern.compile("(?: {0,3}\t| {4})(.*)");

    @Override
    public void process(ProcessingContext context, DocumentBuilder builder, LineSequence lineSequence) {
        builder.setLocator(lineSequence.getCurrentLine().toLocator());
        builder.beginBlock(DocumentBuilder.BlockType.CODE, new Attributes());
        boolean blockHasContent = false;
        Iterator<Line> iterator = lineSequence.with(LinePredicates.matches(PATTERN).or(LinePredicates.empty())).iterator();
        while (iterator.hasNext()) {
            Line line = iterator.next();
            Matcher matcher = PATTERN.matcher(line.getText());
            if (!matcher.matches()) {
                Preconditions.checkState((boolean)line.isEmpty());
                if (!iterator.hasNext()) continue;
                builder.characters("\n");
                continue;
            }
            String content = matcher.group(1);
            if (content.isEmpty() && (!blockHasContent || !iterator.hasNext())) continue;
            blockHasContent = true;
            builder.characters(content);
            builder.characters("\n");
        }
        builder.endBlock();
    }

    @Override
    public boolean canStart(LineSequence lineSequence) {
        Line line = lineSequence.getCurrentLine();
        return line != null && PATTERN.matcher(line.getText()).matches();
    }
}

