/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core;

import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CoreUtil {
    public static final boolean TEST_MODE;
    private static final String FRAMEWORK_VERSION = "4.0.0";
    private static final SAXParserFactory saxParserFactory;

    static {
        String application = System.getProperty("eclipse.application", "");
        if (application.length() > 0) {
            TEST_MODE = application.endsWith("testapplication") || application.endsWith("uitest");
        } else {
            String commands = System.getProperty("eclipse.commands", "");
            TEST_MODE = commands.contains("testapplication\n");
        }
        saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
    }

    public static String toString(Object object) {
        StringBuilder sb = new StringBuilder();
        CoreUtil.toString(sb, object);
        return sb.toString();
    }

    private static void toString(StringBuilder sb, Object object) {
        if (object instanceof Object[]) {
            sb.append("[");
            Object[] entries = (Object[])object;
            boolean prependSeparator = false;
            Object[] objectArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                Object entry = objectArray[n2];
                if (prependSeparator) {
                    sb.append(", ");
                }
                CoreUtil.toString(sb, entry);
                prependSeparator = true;
                ++n2;
            }
            sb.append("]");
        } else if (object instanceof Map) {
            sb.append("{");
            boolean prependSeparator = false;
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (prependSeparator) {
                    sb.append(", ");
                }
                CoreUtil.toString(sb, entry.getKey());
                sb.append("=");
                CoreUtil.toString(sb, entry.getValue());
                prependSeparator = true;
            }
            sb.append("}");
        } else {
            sb.append(object);
        }
    }

    @Deprecated
    public static Version getVersion(Bundle bundle) {
        return bundle.getVersion();
    }

    public static boolean areEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static <T> int compare(Comparable<T> o1, T o2) {
        if (o1 == null) {
            return o2 != null ? 1 : 0;
        }
        if (o2 == null) {
            return -1;
        }
        return o1.compareTo(o2);
    }

    public static boolean propertyEquals(boolean value, Object expectedValue) {
        return expectedValue == null ? value : Boolean.valueOf(value).equals(expectedValue);
    }

    public static void initializeLoggingSettings() {
        CoreUtil.defaultSystemProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
    }

    private static void defaultSystemProperty(String key, String defaultValue) {
        if (System.getProperty(key) == null) {
            System.setProperty(key, defaultValue);
        }
    }

    public static Version getRuntimeVersion() {
        Version result = CoreUtil.parseRuntimeVersion(Runtime.version().toString());
        return result;
    }

    public static Version parseRuntimeVersion(String versionString) {
        if (versionString != null) {
            int firstSeparator = ((String)versionString).indexOf(46);
            if (firstSeparator != -1) {
                try {
                    int secondSeparator = ((String)versionString).indexOf(46, firstSeparator + 1);
                    if (secondSeparator != -1) {
                        int index = CoreUtil.findLastNumberIndex((String)versionString, secondSeparator);
                        String qualifier = ((String)versionString).substring(index + 1);
                        versionString = (qualifier.startsWith("_") || qualifier.startsWith("+")) && qualifier.length() > 1 ? ((String)versionString).substring(0, index + 1) + "." + qualifier.substring(1) : ((String)versionString).substring(0, index + 1);
                        return new Version((String)versionString);
                    }
                    return new Version(((String)versionString).substring(0, CoreUtil.findLastNumberIndex((String)versionString, firstSeparator) + 1));
                }
                catch (IllegalArgumentException secondSeparator) {}
            } else {
                int plusSeparator = ((String)versionString).indexOf(43);
                if (plusSeparator != -1) {
                    return new Version(((String)versionString).substring(0, plusSeparator));
                }
            }
        }
        return Version.emptyVersion;
    }

    private static int findLastNumberIndex(String versionString, int secondSeparator) {
        int lastDigit = secondSeparator;
        int i = secondSeparator + 1;
        while (i < versionString.length()) {
            if (!Character.isDigit(versionString.charAt(i))) break;
            ++lastDigit;
            ++i;
        }
        if (lastDigit == secondSeparator) {
            return secondSeparator - 1;
        }
        return lastDigit;
    }

    public static Version getFrameworkVersion() {
        return new Version(FRAMEWORK_VERSION);
    }

    public static String asFileName(String name) {
        char[] chars;
        StringBuilder sb = new StringBuilder(name.length());
        char[] cArray = chars = name.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.') {
                sb.append(c);
            } else {
                sb.append("%" + Integer.toHexString(c).toUpperCase());
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String decode(String text) {
        char[] chars;
        boolean escaped = false;
        StringBuilder sb = new StringBuilder(text.length());
        StringBuilder escapedText = new StringBuilder(4);
        char[] cArray = chars = text.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.') {
                if (escaped) {
                    escapedText.append(c);
                } else {
                    sb.append(c);
                }
            } else if (c == '%') {
                if (escaped) {
                    throw new IllegalArgumentException("Unexpected '%' sign in '" + text + "'");
                }
                escaped = !escaped;
            } else if (c == '_') {
                if (!escaped) {
                    throw new IllegalArgumentException("Unexpected '_' sign in '" + text + "'");
                }
                try {
                    sb.append((char)Integer.parseInt(escapedText.toString(), 16));
                    escapedText.setLength(0);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid escape code in '" + text + "'");
                }
                escaped = !escaped;
            } else {
                throw new IllegalArgumentException("Unexpected character '" + c + "' in '" + text + "'");
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String encode(String text) {
        char[] chars;
        StringBuilder sb = new StringBuilder(text.length());
        char[] cArray = chars = text.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.') {
                sb.append(c);
            } else {
                sb.append("%");
                sb.append(Integer.toHexString(c).toUpperCase());
                sb.append("_");
            }
            ++n2;
        }
        return sb.toString();
    }

    public static SAXParser newSaxParser() throws SAXException {
        try {
            return saxParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    public static XMLReader newXmlReader() throws SAXException {
        return CoreUtil.newSaxParser().getXMLReader();
    }
}

