/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.egit;

import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.reviewdb.Project;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class GerritToGitMapping {
    private final GerritConfig config;
    private String gerritHost;
    private final String gerritProject;
    private RemoteConfig remote;
    private Repository repository;
    private final TaskRepository taskRepository;

    private static String cleanGerritHttpPrefix(String path) {
        String httpPathPrefix = "/p/";
        int httpPathPrefixIndex = path.indexOf(httpPathPrefix);
        if (httpPathPrefixIndex >= 0) {
            return path.substring(httpPathPrefixIndex + httpPathPrefix.length());
        }
        return path;
    }

    private static String cleanLeadingSlash(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    private static String cleanTrailingDotGit(String path) {
        int dotGitIndex = path.lastIndexOf(".git");
        if (dotGitIndex >= 0) {
            return path.substring(0, dotGitIndex);
        }
        return path;
    }

    private static boolean isHttpUri(URIish fetchUri) {
        String scheme = fetchUri.getScheme();
        return scheme != null && scheme.toLowerCase().startsWith("http");
    }

    static String calcProjectNameFromUri(URIish uri) {
        String path = uri.getPath();
        path = GerritToGitMapping.cleanTrailingDotGit(path);
        if (GerritToGitMapping.isHttpUri(uri)) {
            path = GerritToGitMapping.cleanGerritHttpPrefix(path);
        }
        return GerritToGitMapping.cleanLeadingSlash(path);
    }

    public GerritToGitMapping(TaskRepository taskRepository, GerritConfig config, String gerritProject) {
        this.config = config;
        this.taskRepository = taskRepository;
        this.gerritProject = gerritProject;
    }

    public Repository find() throws IOException {
        if (this.gerritProject == null) {
            return null;
        }
        this.gerritHost = this.getHostFromUrl(this.getGitDaemonUrl());
        if (this.gerritHost != null) {
            this.findMatchingRepository();
        }
        if (this.repository == null) {
            this.gerritHost = this.getHostFromUrl(this.taskRepository.getRepositoryUrl());
            if (this.gerritHost != null) {
                this.findMatchingRepository();
            }
        }
        return this.repository;
    }

    public String getGerritHost() {
        return this.gerritHost;
    }

    public String getGerritProjectName() {
        return this.gerritProject;
    }

    public Project getGerritProject() {
        return new Project(new Project.NameKey(this.gerritProject));
    }

    public RemoteConfig getRemote() {
        return this.remote;
    }

    public Repository getRepository() {
        return this.repository;
    }

    private String getGitDaemonUrl() {
        if (this.config != null) {
            return this.config.getGitDaemonUrl();
        }
        return null;
    }

    private String getHostFromUrl(String url) {
        if (url == null) {
            return null;
        }
        try {
            return new URI(url).getHost();
        }
        catch (URISyntaxException e) {
            GerritCorePlugin.logWarning("Error in task repository URL " + url, e);
            return null;
        }
    }

    private boolean isMatchingRemoteConfig(RemoteConfig remoteConfig) {
        List remoteUris = remoteConfig.getURIs();
        return !remoteUris.isEmpty() && this.isMatchingUri((URIish)remoteUris.get(0));
    }

    private boolean isMatchingUri(URIish uri) {
        String host = uri.getHost();
        return this.gerritHost.equalsIgnoreCase(host) && this.gerritProject.equals(GerritToGitMapping.calcProjectNameFromUri(uri));
    }

    protected RemoteConfig findMatchingRemote() throws IOException {
        List remotes;
        Assert.isNotNull((Object)this.repository);
        try {
            remotes = RemoteConfig.getAllRemoteConfigs((Config)this.repository.getConfig());
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URI in remote configuration", e);
        }
        for (RemoteConfig remote : remotes) {
            if (!this.isMatchingRemoteConfig(remote)) continue;
            return remote;
        }
        return null;
    }

    protected void findMatchingRepository() throws IOException {
        RepositoryUtil repoUtil = this.getRepositoryUtil();
        RepositoryCache repoCache = this.getRepositoryCache();
        for (String dirs : repoUtil.getConfiguredRepositories()) {
            this.repository = repoCache.lookupRepository(new File(dirs));
            this.remote = this.findMatchingRemote();
            if (this.remote == null) continue;
            return;
        }
        this.repository = null;
        this.remote = null;
    }

    RepositoryCache getRepositoryCache() {
        Activator egit = Activator.getDefault();
        return RepositoryCache.INSTANCE;
    }

    RepositoryUtil getRepositoryUtil() {
        Activator egit = Activator.getDefault();
        return RepositoryUtil.INSTANCE;
    }
}

