/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.prettify.common;

import com.google.gerrit.prettify.common.EditList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.diff.Edit;

public class SparseFileContent {
    protected String path;
    protected List<Range> ranges = new ArrayList<Range>();
    protected int size;
    protected boolean missingNewlineAtEnd;
    private transient int currentRangeIdx;

    public int size() {
        return this.size;
    }

    public void setSize(int s) {
        this.size = s;
    }

    public boolean isMissingNewlineAtEnd() {
        return this.missingNewlineAtEnd;
    }

    public void setMissingNewlineAtEnd(boolean missing) {
        this.missingNewlineAtEnd = missing;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String filePath) {
        this.path = filePath;
    }

    public boolean isWholeFile() {
        if (this.size == 0) {
            return true;
        }
        if (1 == this.ranges.size()) {
            Range r = this.ranges.get(0);
            return r.base == 0 && r.end() == this.size;
        }
        return false;
    }

    public String get(int idx) {
        String line = this.getLine(idx);
        if (line == null) {
            throw new ArrayIndexOutOfBoundsException(idx);
        }
        return line;
    }

    public boolean contains(int idx) {
        return this.getLine(idx) != null;
    }

    public int first() {
        return this.ranges.isEmpty() ? this.size() : this.ranges.get((int)0).base;
    }

    public int next(int idx) {
        int high = this.ranges.size();
        if (this.currentRangeIdx < high) {
            Range cur = this.ranges.get(this.currentRangeIdx);
            if (cur.contains(idx + 1)) {
                return idx + 1;
            }
            if (++this.currentRangeIdx < high) {
                return this.ranges.get((int)this.currentRangeIdx).base;
            }
        }
        int low = 0;
        do {
            int mid;
            Range cur;
            if ((cur = this.ranges.get(mid = (low + high) / 2)).contains(idx)) {
                if (cur.contains(idx + 1)) {
                    this.currentRangeIdx = mid;
                    return idx + 1;
                }
                if (mid + 1 < this.ranges.size()) {
                    this.currentRangeIdx = mid + 1;
                    return this.ranges.get((int)this.currentRangeIdx).base;
                }
                return this.size();
            }
            if (idx < cur.base) {
                high = mid;
                continue;
            }
            low = mid + 1;
        } while (low < high);
        return this.size();
    }

    public int mapIndexToLine(int arrayIndex) {
        int origIndex = arrayIndex;
        for (Range r : this.ranges) {
            if (arrayIndex < r.lines.size()) {
                return r.base + arrayIndex;
            }
            arrayIndex -= r.lines.size();
        }
        throw new ArrayIndexOutOfBoundsException(origIndex);
    }

    private String getLine(int idx) {
        int high = this.ranges.size();
        if (this.currentRangeIdx < high) {
            Range next;
            Range cur = this.ranges.get(this.currentRangeIdx);
            if (cur.contains(idx)) {
                return cur.get(idx);
            }
            if (++this.currentRangeIdx < high && (next = this.ranges.get(this.currentRangeIdx)).contains(idx)) {
                return next.get(idx);
            }
        }
        if (this.ranges.isEmpty()) {
            return null;
        }
        int low = 0;
        do {
            int mid;
            Range cur;
            if ((cur = this.ranges.get(mid = (low + high) / 2)).contains(idx)) {
                this.currentRangeIdx = mid;
                return cur.get(idx);
            }
            if (idx < cur.base) {
                high = mid;
                continue;
            }
            low = mid + 1;
        } while (low < high);
        return null;
    }

    public void addLine(int i, String content) {
        Range r;
        if (!this.ranges.isEmpty() && i == this.last().end()) {
            r = this.last();
        } else {
            r = new Range(i);
            this.ranges.add(r);
        }
        r.lines.add(content);
    }

    private Range last() {
        return this.ranges.get(this.ranges.size() - 1);
    }

    public String asString() {
        StringBuilder b = new StringBuilder();
        for (Range r : this.ranges) {
            for (String l : r.lines) {
                b.append(l);
                b.append('\n');
            }
        }
        if (0 < b.length() && this.isMissingNewlineAtEnd()) {
            b.setLength(b.length() - 1);
        }
        return b.toString();
    }

    public SparseFileContent apply(SparseFileContent a, List<Edit> edits) {
        EditList list = new EditList(edits, this.size, a.size(), this.size);
        ArrayList<String> lines = new ArrayList<String>(this.size);
        for (EditList.Hunk hunk : list.getHunks()) {
            while (hunk.next()) {
                if (hunk.isContextLine()) {
                    if (this.contains(hunk.getCurB())) {
                        lines.add(this.get(hunk.getCurB()));
                    } else {
                        lines.add(a.get(hunk.getCurA()));
                    }
                    hunk.incBoth();
                    continue;
                }
                if (hunk.isDeletedA()) {
                    hunk.incA();
                }
                if (!hunk.isInsertedB()) continue;
                lines.add(this.get(hunk.getCurB()));
                hunk.incB();
            }
        }
        Range range = new Range();
        range.lines = lines;
        SparseFileContent r = new SparseFileContent();
        r.setSize(this.size());
        r.setMissingNewlineAtEnd(this.isMissingNewlineAtEnd());
        r.setPath(this.getPath());
        r.ranges.add(range);
        return r;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SparseFileContent[\n");
        for (Range r : this.ranges) {
            b.append("  ");
            b.append(r.toString());
            b.append('\n');
        }
        b.append("]");
        return b.toString();
    }

    static class Range {
        protected int base;
        protected List<String> lines;

        private Range(int b) {
            this.base = b;
            this.lines = new ArrayList<String>();
        }

        protected Range() {
        }

        private String get(int i) {
            return this.lines.get(i - this.base);
        }

        private int end() {
            return this.base + this.lines.size();
        }

        private boolean contains(int i) {
            return this.base <= i && i < this.end();
        }

        public String toString() {
            return "Range[" + this.base + "," + this.end() + ")";
        }
    }
}

