/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.AccountInfoCache;
import com.google.gerrit.reviewdb.PatchLineComment;
import com.google.gerrit.reviewdb.PatchSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommentDetail {
    protected List<PatchLineComment> a;
    protected List<PatchLineComment> b;
    protected AccountInfoCache accounts;
    private transient PatchSet.Id idA;
    private transient PatchSet.Id idB;
    private transient Map<Integer, List<PatchLineComment>> forA;
    private transient Map<Integer, List<PatchLineComment>> forB;

    public CommentDetail(PatchSet.Id idA, PatchSet.Id idB) {
        this.a = new ArrayList<PatchLineComment>();
        this.b = new ArrayList<PatchLineComment>();
        this.idA = idA;
        this.idB = idB;
    }

    protected CommentDetail() {
    }

    public boolean include(PatchLineComment p) {
        PatchSet.Id psId = p.getKey().getParentKey().getParentKey();
        switch (p.getSide()) {
            case 0: {
                if (this.idA != null || !this.idB.equals((Object)psId)) break;
                this.a.add(p);
                return true;
            }
            case 1: {
                if (this.idA != null && this.idA.equals((Object)psId)) {
                    this.a.add(p);
                    return true;
                }
                if (!this.idB.equals((Object)psId)) break;
                this.b.add(p);
                return true;
            }
        }
        return false;
    }

    public void setAccountInfoCache(AccountInfoCache a) {
        this.accounts = a;
    }

    public AccountInfoCache getAccounts() {
        return this.accounts;
    }

    public List<PatchLineComment> getCommentsA() {
        return this.a;
    }

    public List<PatchLineComment> getCommentsB() {
        return this.b;
    }

    public boolean isEmpty() {
        return this.a.isEmpty() && this.b.isEmpty();
    }

    public List<PatchLineComment> getForA(int lineNbr) {
        if (lineNbr == 0) {
            return Collections.emptyList();
        }
        if (this.forA == null) {
            this.forA = this.index(this.a);
        }
        return CommentDetail.get(this.forA, lineNbr);
    }

    public List<PatchLineComment> getForB(int lineNbr) {
        if (lineNbr == 0) {
            return Collections.emptyList();
        }
        if (this.forB == null) {
            this.forB = this.index(this.b);
        }
        return CommentDetail.get(this.forB, lineNbr);
    }

    private static List<PatchLineComment> get(Map<Integer, List<PatchLineComment>> m, int i) {
        List<PatchLineComment> r = m.get(i);
        return r != null ? CommentDetail.orderComments(r) : Collections.emptyList();
    }

    private static List<PatchLineComment> orderComments(List<PatchLineComment> comments) {
        HashMap<String, List<PatchLineComment>> parentMap = new HashMap<String, List<PatchLineComment>>();
        ArrayList<PatchLineComment> rootComments = new ArrayList<PatchLineComment>();
        for (PatchLineComment c : comments) {
            String parentUuid = c.getParentUuid();
            ArrayList<PatchLineComment> l = (ArrayList<PatchLineComment>)parentMap.get(parentUuid);
            if (l == null) {
                l = new ArrayList<PatchLineComment>();
                parentMap.put(parentUuid, l);
            }
            l.add(c);
            if (parentUuid != null) continue;
            rootComments.add(c);
        }
        ArrayList<PatchLineComment> result = new ArrayList<PatchLineComment>();
        CommentDetail.addChildren(parentMap, rootComments, result);
        return result;
    }

    private static void addChildren(Map<String, List<PatchLineComment>> parentMap, List<PatchLineComment> children, List<PatchLineComment> outResult) {
        if (children != null) {
            for (PatchLineComment c : children) {
                outResult.add(c);
                CommentDetail.addChildren(parentMap, parentMap.get(c.getKey().get()), outResult);
            }
        }
    }

    private Map<Integer, List<PatchLineComment>> index(List<PatchLineComment> in) {
        HashMap<Integer, List<PatchLineComment>> r = new HashMap<Integer, List<PatchLineComment>>();
        for (PatchLineComment p : in) {
            List<PatchLineComment> l = r.get(p.getLine());
            if (l == null) {
                l = new ArrayList<PatchLineComment>();
                r.put(p.getLine(), l);
            }
            l.add(p);
        }
        return r;
    }
}

