/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.client;

import com.google.gwt.core.client.JavaScriptObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Dictionary {
    private static Map<String, Dictionary> cache = new HashMap<String, Dictionary>();
    private static final int MAX_KEYS_TO_SHOW = 20;
    private JavaScriptObject dict;
    private String label;

    public static Dictionary getDictionary(String name) {
        Dictionary target = cache.get(name);
        if (target == null) {
            target = new Dictionary(name);
            cache.put(name, target);
        }
        return target;
    }

    static void resourceErrorBadType(String name) {
        throw new MissingResourceException("'" + name + "' is not a JavaScript object and cannot be used as a Dictionary", null, name);
    }

    private Dictionary(String name) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("Cannot create a Dictionary with a null or empty name");
        }
        this.label = "Dictionary " + name;
        this.attach(name);
        if (this.dict == null) {
            throw new MissingResourceException("Cannot find JavaScript object with the name '" + name + "'", name, null);
        }
    }

    public native String get(String var1);

    public Set<String> keySet() {
        HashSet<String> s = new HashSet<String>();
        this.addKeys(s);
        return s;
    }

    public String toString() {
        return this.label;
    }

    public Collection<String> values() {
        ArrayList<String> s = new ArrayList<String>();
        this.addValues(s);
        return s;
    }

    void resourceError(String key) {
        Set<String> s = this.keySet();
        String error = "Cannot find '" + key + "' in " + this;
        if (s.size() < 20) {
            error = error + "\n keys found: " + s;
        }
        throw new MissingResourceException(error, this.toString(), key);
    }

    private native void addKeys(HashSet<String> var1);

    private native void addValues(ArrayList<String> var1);

    private native void attach(String var1);
}

