/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.client.impl;

import com.google.gwtorm.client.Access;
import com.google.gwtorm.client.Key;
import com.google.gwtorm.client.OrmException;
import com.google.gwtorm.client.ResultSet;
import com.google.gwtorm.client.Transaction;
import com.google.gwtorm.client.impl.AbstractTransaction;
import com.google.gwtorm.client.impl.ListResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractAccess<E, K extends Key<?>, T extends AbstractTransaction>
implements Access<E, K> {
    @Override
    public ResultSet<E> get(Iterable<K> keys) throws OrmException {
        ArrayList r = new ArrayList();
        for (Key key : keys) {
            Object o = this.get(key);
            if (o == null) continue;
            r.add(o);
        }
        return new ListResultSet(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, E> toMap(Iterable<E> c) {
        try {
            HashMap r = new HashMap();
            for (E e : c) {
                r.put(this.primaryKey(e), e);
            }
            HashMap hashMap = r;
            return hashMap;
        }
        finally {
            if (c instanceof ResultSet) {
                ((ResultSet)c).close();
            }
        }
    }

    @Override
    public final void insert(Iterable<E> instances) throws OrmException {
        this.doInsert(instances, null);
    }

    @Override
    public final void insert(Iterable<E> instances, Transaction txn) throws OrmException {
        if (txn != null) {
            ((AbstractTransaction)this.cast(txn)).queueInsert(this, instances);
        } else {
            this.insert(instances);
        }
    }

    @Override
    public final void update(Iterable<E> instances) throws OrmException {
        this.doUpdate(instances, null);
    }

    @Override
    public final void update(Iterable<E> instances, Transaction txn) throws OrmException {
        if (txn != null) {
            ((AbstractTransaction)this.cast(txn)).queueUpdate(this, instances);
        } else {
            this.update(instances);
        }
    }

    @Override
    public final void upsert(Iterable<E> instances) throws OrmException {
        this.doUpsert(instances, null);
    }

    @Override
    public final void upsert(Iterable<E> instances, Transaction txn) throws OrmException {
        if (txn != null) {
            ((AbstractTransaction)this.cast(txn)).queueUpsert(this, instances);
        } else {
            this.upsert(instances);
        }
    }

    @Override
    public final void delete(Iterable<E> instances) throws OrmException {
        this.doDelete(instances, null);
    }

    @Override
    public final void delete(Iterable<E> instances, Transaction txn) throws OrmException {
        if (txn != null) {
            ((AbstractTransaction)this.cast(txn)).queueDelete(this, instances);
        } else {
            this.delete(instances);
        }
    }

    protected abstract void doInsert(Iterable<E> var1, T var2) throws OrmException;

    protected abstract void doUpdate(Iterable<E> var1, T var2) throws OrmException;

    protected abstract void doUpsert(Iterable<E> var1, T var2) throws OrmException;

    protected abstract void doDelete(Iterable<E> var1, T var2) throws OrmException;

    private T cast(Transaction txn) {
        return (T)((AbstractTransaction)txn);
    }
}

