/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.blocks;

import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LinePredicates;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.SourceBlock;
import org.eclipse.mylyn.wikitext.commonmark.internal.TextSegment;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlineParser;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.util.Preconditions;

public class FencedCodeBlock
extends SourceBlock {
    private final Pattern openingFencePattern = Pattern.compile("(\\s{0,4})(`{3,}|~{3,})\\s*(?:([^\\s~`]+)[^~`]*)?");

    @Override
    public void process(ProcessingContext context, DocumentBuilder builder, LineSequence lineSequence) {
        Matcher matcher = this.openingFencePattern.matcher(lineSequence.getCurrentLine().getText());
        Preconditions.checkState((boolean)matcher.matches());
        String indent = matcher.group(1);
        boolean indentedCodeBlock = indent != null && indent.length() == 4;
        Pattern closingFencePattern = this.closingFencePattern(matcher);
        Attributes codeAttributes = new Attributes();
        this.addInfoTextCssClass(context, codeAttributes, matcher);
        builder.setLocator(lineSequence.getCurrentLine().toLocator());
        builder.beginBlock(DocumentBuilder.BlockType.CODE, codeAttributes);
        if (indentedCodeBlock) {
            this.outputLine(builder, indent, lineSequence.getCurrentLine());
        }
        lineSequence.advance();
        for (Line line : lineSequence.with(LinePredicates.matches(closingFencePattern).negate())) {
            this.outputLine(builder, indent, line);
        }
        if (indentedCodeBlock && lineSequence.getCurrentLine() != null) {
            this.outputLine(builder, indent, lineSequence.getCurrentLine());
        }
        lineSequence.advance();
        builder.endBlock();
    }

    private void outputLine(DocumentBuilder builder, String indent, Line line) {
        String text = line.getText();
        text = this.removeIndent(indent, text);
        builder.characters(text);
        builder.characters("\n");
    }

    private String removeIndent(String indent, String text) {
        Pattern indentPattern;
        Matcher matcher;
        if (indent != null && indent.length() > 0 && (matcher = (indentPattern = Pattern.compile("\\s{1," + indent.length() + "}(.*)")).matcher(text)).matches()) {
            return matcher.group(1);
        }
        return text;
    }

    private Pattern closingFencePattern(Matcher matcher) {
        String fence = matcher.group(2);
        char fenceDelimiter = fence.charAt(0);
        return Pattern.compile("\\s{0,3}" + fenceDelimiter + "{" + fence.length() + ",}\\s*");
    }

    private void addInfoTextCssClass(ProcessingContext processingContext, Attributes codeAttributes, Matcher matcher) {
        String infoText = matcher.group(3);
        if (infoText != null && !infoText.isEmpty()) {
            InlineParser inlineParser = processingContext.getInlineParser();
            String language = inlineParser.toStringContent(processingContext, new TextSegment(Collections.singletonList(new Line(0, 0, infoText))));
            codeAttributes.setCssClass("language-" + language);
        }
    }

    @Override
    public boolean canStart(LineSequence lineSequence) {
        Line line = lineSequence.getCurrentLine();
        return line != null && this.openingFencePattern.matcher(line.getText()).matches();
    }

    boolean canEnd(Line line, Line startLine) {
        Matcher matcher = this.openingFencePattern.matcher(startLine.getText());
        Preconditions.checkState((boolean)matcher.matches());
        Pattern closingFencePattern = this.closingFencePattern(matcher);
        return closingFencePattern.matcher(line.getText()).matches();
    }
}

