/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui.editor;

import junit.framework.TestCase;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.mylyn.internal.tasks.core.TaskAttachment;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttachmentTableLabelProvider;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;

public class AttachmentTableLabelProviderTest
extends TestCase {
    public void testGetAttachmentId() {
        TaskAttachment attachment = TaskTestUtil.createMockTaskAttachment("1");
        AttachmentTableLabelProvider labelProvider = new AttachmentTableLabelProvider();
        attachment.setUrl(null);
        AttachmentTableLabelProviderTest.assertEquals((String)"", (String)labelProvider.buildTextFromEventIndex(5, (ITaskAttachment)attachment).getString());
        attachment.setUrl("");
        AttachmentTableLabelProviderTest.assertEquals((String)"", (String)labelProvider.buildTextFromEventIndex(5, (ITaskAttachment)attachment).getString());
        attachment.setUrl("http://testi.ng");
        AttachmentTableLabelProviderTest.assertEquals((String)"", (String)labelProvider.buildTextFromEventIndex(5, (ITaskAttachment)attachment).getString());
        attachment.setUrl("http://testi.ng/?some=parameter");
        AttachmentTableLabelProviderTest.assertEquals((String)"", (String)labelProvider.buildTextFromEventIndex(5, (ITaskAttachment)attachment).getString());
        attachment.setUrl("http://testi.ng/?id=myid");
        AttachmentTableLabelProviderTest.assertEquals((String)"myid", (String)labelProvider.buildTextFromEventIndex(5, (ITaskAttachment)attachment).getString());
    }

    public void testGetAttachmentDescription() throws Exception {
        TaskAttachment attachment = TaskTestUtil.createMockTaskAttachment("1");
        attachment.setDescription(null);
        AttachmentTableLabelProvider labelProvider = new AttachmentTableLabelProvider();
        StyledString styledString = labelProvider.buildTextFromEventIndex(1, (ITaskAttachment)attachment);
        AttachmentTableLabelProviderTest.assertEquals((String)"", (String)styledString.getString());
        attachment.setDescription("test");
        styledString = labelProvider.buildTextFromEventIndex(1, (ITaskAttachment)attachment);
        AttachmentTableLabelProviderTest.assertEquals((String)"test", (String)styledString.getString());
    }
}

