/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.precompress.linker;

import com.google.gwt.core.ext.LinkerContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.AbstractLinker;
import com.google.gwt.core.ext.linker.Artifact;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.ConfigurationProperty;
import com.google.gwt.core.ext.linker.EmittedArtifact;
import com.google.gwt.core.ext.linker.LinkerOrder;
import com.google.gwt.core.ext.linker.Shardable;
import com.google.gwt.dev.util.collect.HashSet;
import com.google.gwt.util.regexfilter.RegexFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Shardable
@LinkerOrder(value=LinkerOrder.Order.POST)
public class PrecompressLinker
extends AbstractLinker {
    private static final int BUF_SIZE = 10000;
    private static final String PROP_LEAVE_ORIGINALS = "precompress.leave.originals";
    private static final String PROP_PATH_REGEXES = "precompress.path.regexes";

    private static ConfigurationProperty findProperty(TreeLogger logger, Iterable<ConfigurationProperty> properties, String propName) throws UnableToCompleteException {
        for (ConfigurationProperty prop : properties) {
            if (!prop.getName().equals(propName)) continue;
            return prop;
        }
        logger.log(TreeLogger.ERROR, "Could not find configuration property " + propName);
        throw new UnableToCompleteException();
    }

    public String getDescription() {
        return "PrecompressLinker";
    }

    public ArtifactSet link(TreeLogger logger, LinkerContext context, ArtifactSet artifacts, boolean onePermutation) throws UnableToCompleteException {
        ConfigurationProperty leaveOriginalsProp = PrecompressLinker.findProperty(logger, context.getConfigurationProperties(), PROP_LEAVE_ORIGINALS);
        boolean leaveOriginals = Boolean.valueOf((String)leaveOriginalsProp.getValues().get(0));
        PrecompressFilter filter = new PrecompressFilter(logger.branch(TreeLogger.TRACE, "Analyzing the path patterns"), PrecompressLinker.findProperty(logger, context.getConfigurationProperties(), PROP_PATH_REGEXES).getValues());
        HashSet allPaths = new HashSet();
        for (EmittedArtifact art : artifacts.find(EmittedArtifact.class)) {
            allPaths.add(art.getPartialPath());
        }
        try {
            byte[] buf = new byte[10000];
            ArtifactSet updated = new ArtifactSet((Collection)artifacts);
            for (EmittedArtifact art : artifacts.find(EmittedArtifact.class)) {
                int n;
                if (art.isPrivate() || art.getPartialPath().endsWith(".gz") || allPaths.contains(art.getPartialPath() + ".gz") || !filter.isIncluded(logger.branch(TreeLogger.TRACE, "Checking the path patterns"), art.getPartialPath())) continue;
                TreeLogger compressBranch = logger.branch(TreeLogger.TRACE, "Compressing " + art.getPartialPath());
                InputStream originalBytes = art.getContents(compressBranch);
                ByteArrayOutputStream compressedBytes = new ByteArrayOutputStream();
                GZIPOutputStream gzip = new GZIPOutputStream(compressedBytes);
                int originalLength = 0;
                while ((n = originalBytes.read(buf)) > 0) {
                    originalLength += n;
                    gzip.write(buf, 0, n);
                }
                gzip.close();
                byte[] compressed = compressedBytes.toByteArray();
                if (compressed.length >= originalLength) continue;
                updated.add((Artifact)this.emitBytes(compressBranch, compressed, art.getPartialPath() + ".gz"));
                if (leaveOriginals) continue;
                updated.remove((Object)art);
            }
            return updated;
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Unexpected exception", (Throwable)e);
            throw new UnableToCompleteException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrecompressFilter
    extends RegexFilter {
        public PrecompressFilter(TreeLogger logger, List<String> regexes) throws UnableToCompleteException {
            super(logger, regexes);
        }

        @Override
        protected boolean acceptByDefault() {
            return false;
        }

        @Override
        protected boolean entriesArePositiveByDefault() {
            return true;
        }
    }
}

