/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListInterestSorter;
import org.eclipse.swt.widgets.Control;

public class TaskListInterestSorterTest
extends TestCase {
    private TaskListInterestSorter sorter;
    private AbstractTask task1;
    private AbstractTask task2;

    public void setUp() {
        this.sorter = new TaskListInterestSorter();
        this.task1 = new LocalTask("1", "one");
        this.task2 = new LocalTask("2", "two");
    }

    public void testSortDefault() {
        TaskListInterestSorterTest.assertEquals((int)0, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task1, (Object)this.task2));
        TaskListInterestSorterTest.assertEquals((int)0, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task2, (Object)this.task1));
    }

    public void testSortFallback() {
        this.sorter.setconfiguredSorter((ViewerComparator)new FallbackSorter());
        TaskListInterestSorterTest.assertEquals((int)1, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task1, (Object)this.task2));
        TaskListInterestSorterTest.assertEquals((int)-1, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task2, (Object)this.task1));
    }

    public void testSortCompleted() {
        Date now = new Date();
        this.task1.setCompletionDate(now);
        TaskListInterestSorterTest.assertEquals((int)1, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task1, (Object)this.task2));
        TaskListInterestSorterTest.assertEquals((int)-1, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task2, (Object)this.task1));
        this.task2.setCompletionDate(now);
        TaskListInterestSorterTest.assertEquals((int)0, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task1, (Object)this.task2));
        TaskListInterestSorterTest.assertEquals((int)0, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task2, (Object)this.task1));
    }

    public void testSortScheduled() {
        DayDateRange today = TaskActivityUtil.getCurrentWeek().getToday();
        DayDateRange tomorrow = TaskActivityUtil.getCurrentWeek().getToday().next();
        DayDateRange yesterday = TaskActivityUtil.getCurrentWeek().getToday().previous();
        this.task1.setScheduledForDate((DateRange)today);
        TaskListInterestSorterTest.assertEquals((int)-1, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task1, (Object)this.task2));
        TaskListInterestSorterTest.assertEquals((int)1, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task2, (Object)this.task1));
        this.task2.setScheduledForDate((DateRange)tomorrow);
        TaskListInterestSorterTest.assertEquals((int)-1, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task1, (Object)this.task2));
        TaskListInterestSorterTest.assertEquals((int)1, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task2, (Object)this.task1));
        this.task2.setScheduledForDate((DateRange)yesterday);
        TaskListInterestSorterTest.assertEquals((int)0, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task1, (Object)this.task2));
        TaskListInterestSorterTest.assertEquals((int)0, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task2, (Object)this.task1));
    }

    public void testSortDue() {
        DayDateRange today = TaskActivityUtil.getCurrentWeek().getToday();
        DayDateRange tomorrow = TaskActivityUtil.getCurrentWeek().getToday().next();
        DayDateRange yesterday = TaskActivityUtil.getCurrentWeek().getToday().previous();
        this.task1.setDueDate(new Date(today.getStartDate().getTimeInMillis()));
        TaskListInterestSorterTest.assertEquals((int)-1, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task1, (Object)this.task2));
        TaskListInterestSorterTest.assertEquals((int)1, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task2, (Object)this.task1));
        this.task2.setDueDate(new Date(tomorrow.getStartDate().getTimeInMillis()));
        TaskListInterestSorterTest.assertEquals((int)-1, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task1, (Object)this.task2));
        TaskListInterestSorterTest.assertEquals((int)1, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task2, (Object)this.task1));
        this.task2.setDueDate(new Date(yesterday.getStartDate().getTimeInMillis()));
        TaskListInterestSorterTest.assertEquals((int)0, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task1, (Object)this.task2));
        TaskListInterestSorterTest.assertEquals((int)0, (int)this.sorter.compare((Viewer)new EmptyViewer(), (Object)this.task2, (Object)this.task1));
    }

    public static class EmptyViewer
    extends Viewer {
        public Control getControl() {
            return null;
        }

        public Object getInput() {
            return null;
        }

        public ISelection getSelection() {
            return null;
        }

        public void refresh() {
        }

        public void setInput(Object input) {
        }

        public void setSelection(ISelection selection, boolean reveal) {
        }
    }

    public class FallbackSorter
    extends ViewerComparator {
        public int compare(Viewer v, Object o1, Object o2) {
            if (o1 == TaskListInterestSorterTest.this.task1) {
                return 1;
            }
            return -1;
        }
    }
}

