/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tests.util.TasksUiTestUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class TasksUiUtilTest
extends TestCase {
    private TaskCategory cat1;
    private AbstractTask cat1task1;
    private AbstractTask cat1task2;
    private IWorkbenchPage activePage;
    private TaskList taskList;

    public void setUp() throws Exception {
        this.taskList = TasksUiPlugin.getTaskList();
        TaskTestUtil.resetTaskListAndRepositories();
        TasksUiPlugin.getDefault().getLocalTaskRepository();
        this.cat1 = new TaskCategory("First Category");
        this.taskList.addCategory(this.cat1);
        this.cat1task1 = TasksUiInternal.createNewLocalTask((String)"task 1");
        this.cat1task1.setPriority(ITask.PriorityLevel.P1.toString());
        this.cat1task1.setCompletionDate(new Date());
        this.taskList.addTask((ITask)this.cat1task1, (AbstractTaskContainer)this.cat1);
        this.cat1task2 = TasksUiInternal.createNewLocalTask((String)"task 2");
        this.cat1task2.setPriority(ITask.PriorityLevel.P2.toString());
        this.taskList.addTask((ITask)this.cat1task2, (AbstractTaskContainer)this.cat1);
        TasksUiUtilTest.assertEquals((int)this.cat1.getChildren().size(), (int)2);
        this.activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        TasksUiUtilTest.assertTrue((boolean)this.activePage.closeAllEditors(false));
        TasksUiUtilTest.assertEquals((int)0, (int)this.activePage.getEditorReferences().length);
        TasksUiTestUtil.ensureTasksUiInitialization();
    }

    public void tearDown() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
        this.activePage.closeAllEditors(false);
    }

    public void testOpenTaskFromTask() {
        TasksUiUtil.openTask((ITask)this.cat1task1);
        TasksUiUtilTest.assertEquals((int)1, (int)this.activePage.getEditorReferences().length);
        IEditorPart editor = this.activePage.getEditorReferences()[0].getEditor(true);
        TasksUiUtilTest.assertNotNull((Object)editor);
        TasksUiUtilTest.assertEquals(TaskEditor.class, editor.getClass());
        TasksUiUtil.openTask((ITask)this.cat1task2);
        TasksUiUtilTest.assertEquals((int)2, (int)this.activePage.getEditorReferences().length);
        editor = this.activePage.getEditorReferences()[1].getEditor(true);
        TasksUiUtilTest.assertNotNull((Object)editor);
        TasksUiUtilTest.assertEquals(TaskEditor.class, editor.getClass());
    }

    public void testOpenLocalTask() {
        LocalTask localTask = TasksUiInternal.createNewLocalTask((String)"summary");
        TasksUiUtil.openTask((ITask)localTask);
        TasksUiUtilTest.assertEquals((int)1, (int)this.activePage.getEditorReferences().length);
        IEditorPart editor = this.activePage.getEditorReferences()[0].getEditor(true);
        TasksUiUtilTest.assertEquals(TaskEditor.class, editor.getClass());
    }

    public void testOpenLocalTaskWebBrowserDefault() {
        LocalTask localTask = TasksUiInternal.createNewLocalTask((String)"summary");
        try {
            TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.reporting.open.editor", false);
            TasksUiUtil.openTask((ITask)localTask);
            TasksUiUtilTest.assertEquals((int)1, (int)this.activePage.getEditorReferences().length);
            IEditorPart editor = this.activePage.getEditorReferences()[0].getEditor(true);
            TasksUiUtilTest.assertEquals(TaskEditor.class, editor.getClass());
        }
        finally {
            TasksUiPlugin.getDefault().getPreferenceStore().setToDefault("org.eclipse.mylyn.tasks.ui.reporting.open.editor");
        }
    }
}

