/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.INatExample;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PersistentNatExampleWrapper
extends AbstractNatExample {
    private static final String PROPERTIES_FILE = "natTable.properties";
    private final INatExample example;
    private NatTable natTable;

    public PersistentNatExampleWrapper(INatExample example) {
        this.example = example;
    }

    @Override
    public String getName() {
        return String.valueOf(this.example.getName()) + " (Persisted)";
    }

    @Override
    public String getDescription() {
        return this.example.getDescription();
    }

    @Override
    public String getShortDescription() {
        return this.example.getShortDescription();
    }

    @Override
    public Control createExampleControl(Composite parent) {
        this.natTable = (NatTable)this.example.createExampleControl(parent);
        return this.natTable;
    }

    @Override
    public void onStart() {
        Properties properties = new Properties();
        try {
            System.out.println("Loading NatTable state from natTable.properties");
            properties.load(new FileInputStream(new File(PROPERTIES_FILE)));
            this.natTable.loadState("", properties);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("natTable.properties not found, skipping load");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.example.onStart();
    }

    @Override
    public void onStop() {
        this.example.onStop();
        Properties properties = new Properties();
        this.natTable.saveState("", properties);
        try {
            System.out.println("Saving NatTable state to natTable.properties");
            properties.store(new FileOutputStream(new File(PROPERTIES_FILE)), "NatTable state");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

