/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._300_Data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnInsertEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.stack.DefaultBodyLayerStack;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _304_DynamicColumnExample
extends AbstractNatExample {
    private List<String> columns = new ArrayList<String>();
    private List<Map<String, String>> values = new ArrayList<Map<String, String>>();

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 650, new _304_DynamicColumnExample());
    }

    @Override
    public String getDescription() {
        return "This example shows how to create a custom IColumnPropertyAccessor that supports dynamic column creation at runtime.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        this.columns.add("Column_0");
        this.columns.add("Column_1");
        this.columns.add("Column_2");
        this.values.add(this.createValueRow("Homer"));
        this.values.add(this.createValueRow("Marge"));
        this.values.add(this.createValueRow("Bart"));
        this.values.add(this.createValueRow("Lisa"));
        this.values.add(this.createValueRow("Maggie"));
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        Composite gridPanel = new Composite(panel, 0);
        gridPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)gridPanel);
        Composite buttonPanel = new Composite(panel, 0);
        buttonPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)buttonPanel);
        ConfigRegistry configRegistry = new ConfigRegistry();
        ListDataProvider bodyDataProvider = new ListDataProvider(this.values, (IColumnAccessor)new MyColumnPropertyAccessor());
        final DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        DefaultBodyLayerStack bodyLayerStack = new DefaultBodyLayerStack((IUniqueIndexLayer)bodyDataLayer);
        SimpleColumnHeaderDataProvider columnHeaderDataProvider = new SimpleColumnHeaderDataProvider();
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)columnHeaderDataProvider), (ILayer)bodyLayerStack.getViewportLayer(), bodyLayerStack.getSelectionLayer());
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)new DefaultRowHeaderDataLayer((IDataProvider)new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider)), (ILayer)bodyLayerStack.getViewportLayer(), bodyLayerStack.getSelectionLayer());
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider)), (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)bodyLayerStack, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        NatTable natTable = new NatTable(gridPanel, (ILayer)gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(natTable));
        natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        natTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        Button addColumnButton = new Button(buttonPanel, 8);
        addColumnButton.setText("Add Column");
        addColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newColumn = "Column_" + _304_DynamicColumnExample.this.columns.size();
                _304_DynamicColumnExample.this.columns.add(newColumn);
                for (Map value : _304_DynamicColumnExample.this.values) {
                    String prefix = (String)value.get("Column_0");
                    prefix = prefix.substring(0, prefix.indexOf("_"));
                    value.put(newColumn, String.valueOf(prefix) + "_" + (_304_DynamicColumnExample.this.columns.size() - 1));
                }
                bodyDataLayer.fireLayerEvent((ILayerEvent)new ColumnInsertEvent((ILayer)bodyDataLayer, _304_DynamicColumnExample.this.columns.size() - 1));
            }
        });
        return panel;
    }

    private Map<String, String> createValueRow(String value) {
        HashMap<String, String> valueRow = new HashMap<String, String>();
        int i = 0;
        while (i < this.columns.size()) {
            String column = this.columns.get(i);
            valueRow.put(column, String.valueOf(value) + "_" + i);
            ++i;
        }
        return valueRow;
    }

    class MyColumnPropertyAccessor
    implements IColumnPropertyAccessor<Map<String, String>> {
        MyColumnPropertyAccessor() {
        }

        public Object getDataValue(Map<String, String> rowObject, int columnIndex) {
            return rowObject.get(this.getColumnProperty(columnIndex));
        }

        public void setDataValue(Map<String, String> rowObject, int columnIndex, Object newValue) {
            rowObject.put(this.getColumnProperty(columnIndex), newValue.toString());
        }

        public int getColumnCount() {
            return _304_DynamicColumnExample.this.columns.size();
        }

        public String getColumnProperty(int columnIndex) {
            return (String)_304_DynamicColumnExample.this.columns.get(columnIndex);
        }

        public int getColumnIndex(String propertyName) {
            return _304_DynamicColumnExample.this.columns.indexOf(propertyName);
        }
    }

    class SimpleColumnHeaderDataProvider
    implements IDataProvider {
        SimpleColumnHeaderDataProvider() {
        }

        public Object getDataValue(int columnIndex, int rowIndex) {
            return "Column " + (columnIndex + 1);
        }

        public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
            throw new UnsupportedOperationException();
        }

        public int getColumnCount() {
            return _304_DynamicColumnExample.this.columns.size();
        }

        public int getRowCount() {
            return 1;
        }
    }
}

