/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._500_Layers._501_Data;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DummyModifiableBodyDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _5012_PercentageSizingDataLayerExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 850, new _5012_PercentageSizingDataLayerExample());
    }

    @Override
    public String getDescription() {
        return "This example shows some examples for simple NatTable compositions that are using percentage sizing.\n\nFirst table:\tAll columns and all rows have the same size by calculating the size dependent on the available width\nSecond table:\tAll columns have fixed percentage values (25% / 25% / 50%)\nThird table:\tColumn 1 and 3 are configured to take 40% of the available space each, column 2 will take the rest\nFourth table:\tColumn 1 and 2 are configured for 100 pixels width, column 3 will take the rest";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        Composite simplePanel = new Composite(panel, 0);
        simplePanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)simplePanel);
        Composite buttonPanel = new Composite(panel, 0);
        buttonPanel.setLayout((Layout)new RowLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        final DummyModifiableBodyDataProvider dataProvider = new DummyModifiableBodyDataProvider(3, 2);
        final DataLayer n1DataLayer = new DataLayer((IDataProvider)dataProvider);
        n1DataLayer.setColumnPercentageSizing(true);
        n1DataLayer.setRowPercentageSizing(true);
        SelectionLayer layer = new SelectionLayer((IUniqueIndexLayer)n1DataLayer);
        layer.setRegionName("BODY");
        final NatTable n1 = new NatTable(simplePanel, 538181632, (ILayer)layer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)n1);
        final DataLayer n2DataLayer = new DataLayer((IDataProvider)dataProvider);
        n2DataLayer.setColumnWidthPercentageByPosition(0, 25);
        n2DataLayer.setColumnWidthPercentageByPosition(1, 25);
        n2DataLayer.setColumnWidthPercentageByPosition(2, 50);
        layer = new SelectionLayer((IUniqueIndexLayer)n2DataLayer);
        layer.setRegionName("BODY");
        final NatTable n2 = new NatTable(simplePanel, 538181632, (ILayer)layer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)n2);
        final DataLayer n3DataLayer = new DataLayer((IDataProvider)dataProvider);
        n3DataLayer.setColumnPercentageSizing(true);
        n3DataLayer.setColumnWidthPercentageByPosition(0, 40);
        n3DataLayer.setColumnWidthPercentageByPosition(2, 40);
        layer = new SelectionLayer((IUniqueIndexLayer)n3DataLayer);
        layer.setRegionName("BODY");
        final NatTable n3 = new NatTable(simplePanel, 538181632, (ILayer)layer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)n3);
        final DataLayer mixDataLayer = new DataLayer((IDataProvider)dataProvider);
        mixDataLayer.setColumnPercentageSizing(true);
        mixDataLayer.setColumnPercentageSizing(0, false);
        mixDataLayer.setColumnPercentageSizing(1, false);
        mixDataLayer.setColumnWidthByPosition(0, 100);
        mixDataLayer.setColumnWidthByPosition(1, 100);
        layer = new SelectionLayer((IUniqueIndexLayer)mixDataLayer);
        layer.setRegionName("BODY");
        final NatTable mix = new NatTable(simplePanel, 538181632, (ILayer)layer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mix);
        Button addColumnButton = new Button(buttonPanel, 8);
        addColumnButton.setText("add column - no width");
        addColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                dataProvider.setColumnCount(dataProvider.getColumnCount() + 1);
                n1.refresh();
                n2.refresh();
                n3.refresh();
                mix.refresh();
            }
        });
        Button addColumnButton2 = new Button(buttonPanel, 8);
        addColumnButton2.setText("add column - 20 percent width");
        addColumnButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                dataProvider.setColumnCount(dataProvider.getColumnCount() + 1);
                n1DataLayer.setColumnWidthPercentageByPosition(dataProvider.getColumnCount() - 1, 20);
                n2DataLayer.setColumnWidthPercentageByPosition(dataProvider.getColumnCount() - 1, 20);
                n3DataLayer.setColumnWidthPercentageByPosition(dataProvider.getColumnCount() - 1, 20);
                mixDataLayer.setColumnWidthPercentageByPosition(dataProvider.getColumnCount() - 1, 20);
                n1.refresh();
                n2.refresh();
                n3.refresh();
                mix.refresh();
            }
        });
        return panel;
    }
}

