/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._500_Layers._504_Viewport;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.data.ExtendedReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.GridLineCellLayerPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.print.command.MultiTurnViewportOffCommandHandler;
import org.eclipse.nebula.widgets.nattable.print.command.MultiTurnViewportOnCommandHandler;
import org.eclipse.nebula.widgets.nattable.util.ClientAreaAdapter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.nebula.widgets.nattable.viewport.IScroller;
import org.eclipse.nebula.widgets.nattable.viewport.SliderScroller;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;

public class _5042_HorizontalSplitViewportExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new _5042_HorizontalSplitViewportExample());
    }

    @Override
    public String getDescription() {
        return "This example shows a NatTable that contains two separately scrollable horzizontal split viewports.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday", "address.street", "address.housenumber", "address.postalCode", "address.city"};
        ExtendedReflectiveColumnPropertyAccessor columnPropertyAccessor = new ExtendedReflectiveColumnPropertyAccessor(propertyNames);
        ListDataProvider bodyDataProvider = new ListDataProvider(PersonService.getPersonsWithAddress((int)50), (IColumnAccessor)columnPropertyAccessor);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        bodyDataLayer.setLayerPainter((ILayerPainter)new GridLineCellLayerPainter(true, false));
        final ViewportLayer viewportLayerLeft = new ViewportLayer((IUniqueIndexLayer)bodyDataLayer);
        viewportLayerLeft.setMaxColumnPosition(5);
        ViewportLayer viewportLayerRight = new ViewportLayer((IUniqueIndexLayer)bodyDataLayer);
        viewportLayerRight.setMinColumnPosition(5);
        CompositeLayer compositeLayer = new CompositeLayer(2, 1);
        compositeLayer.setChildLayer("REGION_A", (ILayer)viewportLayerLeft, 0, 0);
        compositeLayer.setChildLayer("REGION_B", (ILayer)viewportLayerRight, 1, 0);
        compositeLayer.registerCommandHandler((ILayerCommandHandler)new MultiTurnViewportOnCommandHandler(new ViewportLayer[]{viewportLayerLeft, viewportLayerRight}));
        compositeLayer.registerCommandHandler((ILayerCommandHandler)new MultiTurnViewportOffCommandHandler(new ViewportLayer[]{viewportLayerLeft, viewportLayerRight}));
        int leftWidth = bodyDataLayer.getStartXOfColumnPosition(2);
        ClientAreaAdapter leftClientAreaAdapter = new ClientAreaAdapter(viewportLayerLeft.getClientAreaProvider());
        leftClientAreaAdapter.setWidth(leftWidth);
        viewportLayerLeft.setClientAreaProvider((IClientAreaProvider)leftClientAreaAdapter);
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        NatTable natTable = new NatTable(composite, (ILayer)compositeLayer);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        natTable.setLayoutData((Object)gridData);
        this.createSplitSliders(composite, viewportLayerLeft, viewportLayerRight);
        natTable.addOverlayPainter(new IOverlayPainter(){

            public void paintOverlay(GC gc, ILayer layer) {
                Color beforeColor = gc.getForeground();
                gc.setForeground(GUIHelper.COLOR_GRAY);
                int viewportBorderX = viewportLayerLeft.getWidth() - 1;
                gc.drawLine(viewportBorderX, 0, viewportBorderX, layer.getHeight() - 1);
                gc.setForeground(beforeColor);
            }
        });
        return composite;
    }

    private void createSplitSliders(Composite natTableParent, final ViewportLayer left, ViewportLayer right) {
        Composite sliderComposite = new Composite(natTableParent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.heightHint = 17;
        sliderComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        sliderComposite.setLayout((Layout)gridLayout);
        Composite sliderLeftComposite = new Composite(sliderComposite, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                int width = ((ClientAreaAdapter)left.getClientAreaProvider()).getWidth();
                return new Point(width, 17);
            }
        };
        sliderLeftComposite.setLayout((Layout)new FillLayout());
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 1;
        sliderLeftComposite.setLayoutData((Object)gridData);
        Slider sliderLeft = new Slider(sliderLeftComposite, 256);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        sliderLeft.setLayoutData((Object)gridData);
        left.setHorizontalScroller((IScroller)new SliderScroller(sliderLeft));
        Slider sliderRight = new Slider(sliderComposite, 256);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        sliderRight.setLayoutData((Object)gridData);
        right.setHorizontalScroller((IScroller)new SliderScroller(sliderRight));
    }
}

