/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._600_GlazedLists._604_Tree;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.TreeList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDateDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonWithAddress;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeData;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeRowModel;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.AbstractOverrider;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeCollapseAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandToLevelCommand;
import org.eclipse.nebula.widgets.nattable.tree.config.TreeConfigAttributes;
import org.eclipse.nebula.widgets.nattable.tree.painter.IndentedTreeImagePainter;
import org.eclipse.nebula.widgets.nattable.tree.painter.TreeImagePainter;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemState;
import org.eclipse.nebula.widgets.nattable.ui.menu.MenuItemProviders;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuAction;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class _6042_TreeStructureGridExample
extends AbstractNatExample {
    public static final String MARRIED_LABEL = "marriedLabel";
    public static final String DATE_LABEL = "dateLabel";

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new _6042_TreeStructureGridExample());
    }

    @Override
    public String getDescription() {
        return "This example shows how to create a tree within a grid. It creates a tree structure where the tree nodes are newly added elements that contain all children. It also shows how to create a multi level tree and how to exchange the tree painter via configuration.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        ConfigRegistry configRegistry = new ConfigRegistry();
        String[] propertyNames = new String[]{"lastName", "firstName", "gender", "married", "birthday"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("birthday", "Birthday");
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        BodyLayerStack bodyLayerStack = new BodyLayerStack(PersonService.getPersonsWithAddress((int)5), (IColumnPropertyAccessor<PersonWithAddress>)columnPropertyAccessor, new PersonWithAddressTwoLevelTreeFormat());
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)bodyLayerStack, bodyLayerStack.getSelectionLayer());
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(bodyLayerStack.getBodyDataProvider());
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)bodyLayerStack, bodyLayerStack.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)bodyLayerStack, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        final NatTable natTable = new NatTable(container, (ILayer)gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(), "NORMAL", _6042_TreeStructureGridExample.MARRIED_LABEL);
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDateDisplayConverter("MM/dd/yyyy"), "NORMAL", _6042_TreeStructureGridExample.DATE_LABEL);
                TreeImagePainter treeImagePainter = new TreeImagePainter(false, GUIHelper.getImage((String)"right"), GUIHelper.getImage((String)"right_down"), null);
                BackgroundPainter treeStructurePainter = new BackgroundPainter((ICellPainter)new PaddingDecorator((ICellPainter)new IndentedTreeImagePainter(10, null, CellEdgeEnum.LEFT, (ICellPainter)treeImagePainter, false, 2, true), 0, 5, 0, 5, false));
                configRegistry.registerConfigAttribute(TreeConfigAttributes.TREE_STRUCTURE_PAINTER, (Object)treeStructurePainter, "NORMAL");
            }
        });
        natTable.addConfiguration((IConfiguration)new TreeDebugMenuConfiguration(natTable));
        natTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        Composite buttonPanel = new Composite(container, 0);
        buttonPanel.setLayout((Layout)new RowLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        Button collapseAllButton = new Button(buttonPanel, 8);
        collapseAllButton.setText("Collapse All");
        collapseAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                natTable.doCommand((ILayerCommand)new TreeCollapseAllCommand());
            }
        });
        Button expandAllButton = new Button(buttonPanel, 8);
        expandAllButton.setText("Expand All");
        expandAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                natTable.doCommand((ILayerCommand)new TreeExpandAllCommand());
            }
        });
        Button expandToLevelButton = new Button(buttonPanel, 8);
        expandToLevelButton.setText("Expand To Level");
        expandToLevelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                natTable.doCommand((ILayerCommand)new TreeExpandToLevelCommand(1));
            }
        });
        return container;
    }

    class BodyLayerStack
    extends AbstractLayerTransform {
        private final TreeList treeList;
        private final IRowDataProvider bodyDataProvider;
        private final SelectionLayer selectionLayer;

        public BodyLayerStack(List<PersonWithAddress> values, IColumnPropertyAccessor<PersonWithAddress> columnPropertyAccessor, TreeList.Format treeFormat) {
            EventList eventList = GlazedLists.eventList(values);
            TransformedList rowObjectsGlazedList = GlazedLists.threadSafeList((EventList)eventList);
            SortedList sortedList = new SortedList((EventList)rowObjectsGlazedList, null);
            this.treeList = new TreeList((EventList)sortedList, treeFormat, TreeList.nodesStartExpanded());
            this.bodyDataProvider = new ListDataProvider((List)this.treeList, (IColumnAccessor)new PersonWithAddressTreeColumnPropertyAccessor(columnPropertyAccessor));
            DataLayer bodyDataLayer = new DataLayer((IDataProvider)this.bodyDataProvider);
            bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new AbstractOverrider(){

                public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
                    Object rowObject = BodyLayerStack.this.bodyDataProvider.getRowObject(rowPosition);
                    if (rowObject instanceof PersonWithAddress) {
                        if (columnPosition == 3) {
                            configLabels.addLabel(_6042_TreeStructureGridExample.MARRIED_LABEL);
                        } else if (columnPosition == 4) {
                            configLabels.addLabel(_6042_TreeStructureGridExample.DATE_LABEL);
                        }
                    }
                }
            });
            GlazedListsEventLayer glazedListsEventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)bodyDataLayer, (EventList)this.treeList);
            GlazedListTreeData treeData = new GlazedListTreeData(this.treeList);
            GlazedListTreeRowModel treeRowModel = new GlazedListTreeRowModel(treeData);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)glazedListsEventLayer);
            TreeLayer treeLayer = new TreeLayer((IUniqueIndexLayer)this.selectionLayer, (ITreeRowModel)treeRowModel);
            ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)treeLayer);
            this.setUnderlyingLayer((ILayer)viewportLayer);
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }

        public TreeList<PersonWithAddress> getTreeList() {
            return this.treeList;
        }

        public IDataProvider getBodyDataProvider() {
            return this.bodyDataProvider;
        }
    }

    class FirstNameGroup
    implements Comparable<FirstNameGroup> {
        String lastName;
        String firstName;

        public FirstNameGroup(String lastName, String firstName) {
            this.lastName = lastName;
            this.firstName = firstName;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.firstName == null ? 0 : this.firstName.hashCode());
            result = 31 * result + (this.lastName == null ? 0 : this.lastName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FirstNameGroup other = (FirstNameGroup)obj;
            if (this.firstName == null ? other.firstName != null : !this.firstName.equals(other.firstName)) {
                return false;
            }
            return !(this.lastName == null ? other.lastName != null : !this.lastName.equals(other.lastName));
        }

        public String toString() {
            return this.firstName;
        }

        @Override
        public int compareTo(FirstNameGroup o) {
            return this.firstName.compareTo(o.firstName);
        }
    }

    class LastNameGroup
    implements Comparable<LastNameGroup> {
        int id;
        String lastName;

        public LastNameGroup(int id, String lastName) {
            this.id = id;
            this.lastName = lastName;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + (this.lastName == null ? 0 : this.lastName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LastNameGroup other = (LastNameGroup)obj;
            if (this.id != other.id) {
                return false;
            }
            return !(this.lastName == null ? other.lastName != null : !this.lastName.equals(other.lastName));
        }

        public String toString() {
            return this.lastName;
        }

        @Override
        public int compareTo(LastNameGroup o) {
            return this.lastName.compareTo(o.lastName);
        }
    }

    private class PersonWithAddressTreeColumnPropertyAccessor
    implements IColumnPropertyAccessor<Object> {
        private IColumnPropertyAccessor<PersonWithAddress> cpa;

        public PersonWithAddressTreeColumnPropertyAccessor(IColumnPropertyAccessor<PersonWithAddress> cpa) {
            this.cpa = cpa;
        }

        public Object getDataValue(Object rowObject, int columnIndex) {
            if (rowObject instanceof PersonWithAddress) {
                return this.cpa.getDataValue((Object)((PersonWithAddress)rowObject), columnIndex);
            }
            if (columnIndex == 0) {
                return rowObject;
            }
            return null;
        }

        public void setDataValue(Object rowObject, int columnIndex, Object newValue) {
            if (rowObject instanceof PersonWithAddress) {
                this.cpa.setDataValue((Object)((PersonWithAddress)rowObject), columnIndex, newValue);
            }
        }

        public int getColumnCount() {
            return this.cpa.getColumnCount();
        }

        public String getColumnProperty(int columnIndex) {
            return this.cpa.getColumnProperty(columnIndex);
        }

        public int getColumnIndex(String propertyName) {
            return this.cpa.getColumnIndex(propertyName);
        }
    }

    private class PersonWithAddressTreeFormat
    implements TreeList.Format<Object> {
        private PersonWithAddressTreeFormat() {
        }

        public void getPath(List<Object> path, Object element) {
            if (element instanceof PersonWithAddress) {
                PersonWithAddress ele = (PersonWithAddress)element;
                path.add(new LastNameGroup(ele.getId(), ele.getLastName()));
            }
            path.add(element);
        }

        public boolean allowsChildren(Object element) {
            return true;
        }

        public Comparator<? super Object> getComparator(int depth) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    String e1 = o1 instanceof PersonWithAddress ? ((PersonWithAddress)o1).getLastName() : o1.toString();
                    String e2 = o2 instanceof PersonWithAddress ? ((PersonWithAddress)o2).getLastName() : o2.toString();
                    return e1.compareTo(e2);
                }
            };
        }
    }

    private class PersonWithAddressTwoLevelTreeFormat
    implements TreeList.Format<Object> {
        AtomicInteger counter = new AtomicInteger();
        Map<String, LastNameGroup> lastNames = new HashMap<String, LastNameGroup>();
        Map<String, FirstNameGroup> firstNames = new HashMap<String, FirstNameGroup>();

        private PersonWithAddressTwoLevelTreeFormat() {
        }

        public void getPath(List<Object> path, Object element) {
            if (element instanceof PersonWithAddress) {
                PersonWithAddress ele = (PersonWithAddress)element;
                if (!this.lastNames.containsKey(ele.getLastName())) {
                    this.lastNames.put(ele.getLastName(), new LastNameGroup(this.counter.incrementAndGet(), ele.getLastName()));
                }
                path.add(this.lastNames.get(ele.getLastName()));
                String firstNameKey = String.valueOf(ele.getLastName()) + "_" + ele.getFirstName();
                if (!this.firstNames.containsKey(firstNameKey)) {
                    this.firstNames.put(firstNameKey, new FirstNameGroup(ele.getLastName(), ele.getFirstName()));
                }
                path.add(this.firstNames.get(firstNameKey));
            }
            path.add(element);
        }

        public boolean allowsChildren(Object element) {
            return true;
        }

        public Comparator<? super Object> getComparator(final int depth) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    String e1;
                    String string = o1 instanceof PersonWithAddress ? (depth == 0 ? ((PersonWithAddress)o1).getLastName() : ((PersonWithAddress)o1).getFirstName()) : (e1 = o1.toString());
                    String e2 = o2 instanceof PersonWithAddress ? (depth == 0 ? ((PersonWithAddress)o2).getLastName() : ((PersonWithAddress)o2).getFirstName()) : o2.toString();
                    return e1.compareTo(e2);
                }
            };
        }
    }

    class TreeDebugMenuConfiguration
    extends AbstractUiBindingConfiguration {
        private final Menu menu;

        public TreeDebugMenuConfiguration(final NatTable natTable) {
            this.menu = new PopupMenuBuilder(natTable).withMenuItemProvider("expandToLevel", new IMenuItemProvider(){

                public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                    MenuItem menuItem = new MenuItem(popupMenu, 8);
                    menuItem.setText("Expand 1 level");
                    menuItem.setEnabled(true);
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            NatEventData eventData = MenuItemProviders.getNatEventData((SelectionEvent)event);
                            int rowIndex = natTable.getRowIndexByPosition(eventData.getRowPosition());
                            natTable.doCommand((ILayerCommand)new TreeExpandToLevelCommand(Integer.valueOf(rowIndex), 1));
                        }
                    });
                }
            }).withVisibleState("expandToLevel", new IMenuItemState(){

                public boolean isActive(NatEventData natEventData) {
                    ILayerCell cell = natTable.getCellByPosition(natEventData.getColumnPosition(), natEventData.getRowPosition());
                    return cell.getConfigLabels().hasLabel("TREE_COLUMN_CELL");
                }
            }).withInspectLabelsMenuItem().build();
        }

        public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
            uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, null, 3), (IMouseAction)new PopupMenuAction(this.menu));
        }
    }
}

