/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._102_Configuration;

import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.stack.DummyGridLayerStack;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class Tooltips
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new Tooltips());
    }

    @Override
    public Control createExampleControl(Composite parent) {
        NatTable natTable = new NatTable(parent, (ILayer)new DummyGridLayerStack(20, 100));
        this.attachToolTip(natTable);
        return natTable;
    }

    private void attachToolTip(NatTable natTable) {
        ExampleNatTableToolTip toolTip = new ExampleNatTableToolTip(natTable);
        toolTip.setBackgroundColor(natTable.getDisplay().getSystemColor(3));
        toolTip.setPopupDelay(500);
        toolTip.activate();
        toolTip.setShift(new Point(10, 10));
    }

    private class ExampleNatTableToolTip
    extends DefaultToolTip {
        private NatTable natTable;

        public ExampleNatTableToolTip(NatTable natTable) {
            super((Control)natTable, 2, false);
            this.natTable = natTable;
        }

        protected Object getToolTipArea(Event event) {
            int col = this.natTable.getColumnPositionByX(event.x);
            int row = this.natTable.getRowPositionByY(event.y);
            return new Point(col, row);
        }

        protected String getText(Event event) {
            int col = this.natTable.getColumnPositionByX(event.x);
            int row = this.natTable.getRowPositionByY(event.y);
            return "Cell Position: (" + col + "," + row + ")";
        }

        protected Composite createToolTipContentArea(Event event, Composite parent) {
            return super.createToolTipContentArea(event, parent);
        }
    }
}

