/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._104_Styling;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.dataset.person.SimplePerson;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DummyColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultGridLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.stack.DefaultBodyLayerStack;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CustomLineBorderDecorator;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.TextDecorationEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class _001_Custom_styling_of_specific_cells
extends AbstractNatExample {
    private static final String FOO_LABEL = "FOO";
    private static final String BAR_LABEL = "BAR";

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(800, 600, new _001_Custom_styling_of_specific_cells());
    }

    @Override
    public String getDescription() {
        return "NatTable has a flexible mechanism for customizing styles for specific cells.\nFirst an IConfigLabelAccumulator is used to tag the cells you want to customize with a custom label.\nThen a new style is registered in the config registry for the custom label.\n\nThis example shows a trivial example that simply changes the background color for the cell at column, row index (1, 5).\nIt also shows decorating text underlined and strikethrough for the cell at column, row index (1, 10),\nand looking at row 13 you will see how to use the CustomLineBorderDecorator to add a border around multiple cells.\nYou can change the IConfigLabelAccumulator to target arbitrary other cells, and you can also modify any other style\nattributes you wish. You can also register custom display converters, editable rules, etc. in the same way.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        ArrayList<SimplePerson> myList = new ArrayList<SimplePerson>();
        int i = 1;
        while (i <= 100) {
            myList.add(new SimplePerson(i, "Joe" + i, new Date()));
            ++i;
        }
        String[] propertyNames = new String[]{"id", "name", "birthDate"};
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        ListDataProvider listDataProvider = new ListDataProvider(myList, (IColumnAccessor)columnPropertyAccessor);
        DefaultGridLayer gridLayer = new DefaultGridLayer((IDataProvider)listDataProvider, (IDataProvider)new DummyColumnHeaderDataProvider((IDataProvider)listDataProvider));
        final DefaultBodyLayerStack bodyLayer = gridLayer.getBodyLayer();
        IConfigLabelAccumulator cellLabelAccumulator = new IConfigLabelAccumulator(){

            public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
                int columnIndex = bodyLayer.getColumnIndexByPosition(columnPosition);
                int rowIndex = bodyLayer.getRowIndexByPosition(rowPosition);
                if (columnIndex == 1 && rowIndex == 5) {
                    configLabels.addLabel(_001_Custom_styling_of_specific_cells.FOO_LABEL);
                }
                if (columnIndex == 1 && rowIndex == 10) {
                    configLabels.addLabel(_001_Custom_styling_of_specific_cells.BAR_LABEL);
                }
                if (rowIndex == 13) {
                    configLabels.addLabel("topLineBorderLabel");
                    configLabels.addLabel("bottomLineBorderLabel");
                    if (columnIndex == 0) {
                        configLabels.addLabel("leftLineBorderLabel");
                    }
                    if (columnIndex == 2) {
                        configLabels.addLabel("rightLineBorderLabel");
                    }
                }
            }
        };
        bodyLayer.setConfigLabelAccumulator(cellLabelAccumulator);
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration(){
            {
                this.cellPainter = new CustomLineBorderDecorator((ICellPainter)new TextPainter());
                this.borderStyle = new BorderStyle(2, GUIHelper.COLOR_BLUE, BorderStyle.LineStyleEnum.DASHDOT);
            }
        });
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                Style cellStyle = new Style();
                cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_GREEN);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", _001_Custom_styling_of_specific_cells.FOO_LABEL);
                cellStyle = new Style();
                cellStyle.setAttributeValue(CellStyleAttributes.TEXT_DECORATION, (Object)TextDecorationEnum.UNDERLINE_STRIKETHROUGH);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", _001_Custom_styling_of_specific_cells.BAR_LABEL);
            }
        });
        natTable.configure();
        return natTable;
    }
}

