/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._110_Editing;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.summaryrow.DefaultSummaryRowConfiguration;
import org.eclipse.nebula.widgets.nattable.summaryrow.ISummaryProvider;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummationSummaryProvider;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;

class CalculatingSummaryRowConfiguration
extends DefaultSummaryRowConfiguration {
    private final IDataProvider dataProvider;

    public CalculatingSummaryRowConfiguration(IDataProvider dataProvider) {
        this.dataProvider = dataProvider;
        this.summaryRowBgColor = GUIHelper.COLOR_BLUE;
        this.summaryRowFgColor = GUIHelper.COLOR_WHITE;
    }

    public void addSummaryProviderConfig(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)new SummationSummaryProvider(this.dataProvider), "NORMAL", "SummaryRow");
        configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)new AverageSummaryProvider(), "NORMAL", "SummaryColumn_4");
    }

    class AverageSummaryProvider
    implements ISummaryProvider {
        AverageSummaryProvider() {
        }

        public Object summarize(int columnIndex) {
            double total = 0.0;
            int rowCount = CalculatingSummaryRowConfiguration.this.dataProvider.getRowCount();
            int rowIndex = 0;
            while (rowIndex < rowCount) {
                Object dataValue = CalculatingSummaryRowConfiguration.this.dataProvider.getDataValue(columnIndex, rowIndex);
                total += Double.parseDouble(dataValue.toString());
                ++rowIndex;
            }
            return total / (double)rowCount;
        }
    }
}

