/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.SortedList;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.blink.BlinkConfigAttributes;
import org.eclipse.nebula.widgets.nattable.blink.BlinkingCellResolver;
import org.eclipse.nebula.widgets.nattable.blink.IBlinkingCellResolver;
import org.eclipse.nebula.widgets.nattable.columnChooser.command.DisplayColumnChooserCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.BlinkingRowDataFixture;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.RowDataListFixture;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.PersistentNatExampleWrapper;
import org.eclipse.nebula.widgets.nattable.examples.examples._110_Editing.EditableGridExample;
import org.eclipse.nebula.widgets.nattable.examples.examples._131_Filtering.FilterRowGridExample;
import org.eclipse.nebula.widgets.nattable.examples.fixtures.FullFeaturedBodyLayerStack;
import org.eclipse.nebula.widgets.nattable.examples.fixtures.FullFeaturedColumnHeaderLayerStack;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultSummaryRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.summaryrow.DefaultSummaryRowConfiguration;
import org.eclipse.nebula.widgets.nattable.summaryrow.ISummaryProvider;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummationSummaryProvider;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.nebula.widgets.nattable.widget.WaitDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class _900_Everything_but_the_kitchen_sink
extends AbstractNatExample {
    private static final String BLINK_UP_CONFIG_LABEL = "blinkUpConfigLabel";
    private static final String BLINK_DOWN_CONFIG_LABEL = "blinkDownConfigLabel";
    private EventList<BlinkingRowDataFixture> baseEventList;
    private PropertyChangeListener propertyChangeListener;
    private ListDataProvider<BlinkingRowDataFixture> bodyDataProvider;
    private NatTable natTable;
    private ScheduledExecutorService scheduledThreadPool;
    private final Random random = new Random();
    private static final int DATASET_SIZE = 52000;

    public static void main(String[] args) {
        StandaloneNatExampleRunner.run(1000, 800, new PersistentNatExampleWrapper(new _900_Everything_but_the_kitchen_sink()));
    }

    @Override
    public String getDescription() {
        return "The example with everything. Well, not quite everything, but a lot.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = RowDataListFixture.getPropertyNames();
        Map propertyToLabelMap = RowDataListFixture.getPropertyToLabelMap();
        ConfigRegistry configRegistry = new ConfigRegistry();
        ColumnGroupModel columnGroupModel = new ColumnGroupModel();
        LinkedList rowData = new LinkedList();
        this.baseEventList = GlazedLists.threadSafeList((EventList)GlazedLists.eventList(rowData));
        ObservableElementList observableElementList = new ObservableElementList(this.baseEventList, GlazedLists.beanConnector(BlinkingRowDataFixture.class));
        FilterList filterList = new FilterList((EventList)observableElementList);
        SortedList sortedList = new SortedList((EventList)filterList, null);
        FullFeaturedBodyLayerStack<BlinkingRowDataFixture> bodyLayer = new FullFeaturedBodyLayerStack<BlinkingRowDataFixture>((EventList<BlinkingRowDataFixture>)sortedList, new IRowIdAccessor<BlinkingRowDataFixture>(){

            public Serializable getRowId(BlinkingRowDataFixture rowObject) {
                return rowObject.getSecurity_description();
            }
        }, propertyNames, (IConfigRegistry)configRegistry, columnGroupModel);
        this.bodyDataProvider = bodyLayer.getBodyDataProvider();
        this.propertyChangeListener = bodyLayer.getGlazedListEventsLayer();
        this.registerBlinkingConfigCells(configRegistry);
        FullFeaturedColumnHeaderLayerStack<BlinkingRowDataFixture> columnHeaderLayer = new FullFeaturedColumnHeaderLayerStack<BlinkingRowDataFixture>((SortedList<BlinkingRowDataFixture>)sortedList, (FilterList<BlinkingRowDataFixture>)filterList, propertyNames, propertyToLabelMap, (ILayer)bodyLayer, bodyLayer.getSelectionLayer(), columnGroupModel, (IConfigRegistry)configRegistry);
        this.setUpColumnGroups(columnHeaderLayer);
        DefaultSummaryRowHeaderDataProvider rowHeaderDataProvider = new DefaultSummaryRowHeaderDataProvider(this.bodyDataProvider);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        rowHeaderDataLayer.setDefaultColumnWidth(50);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, bodyLayer, bodyLayer.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider(columnHeaderLayer.getColumnHeaderDataProvider(), (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, columnHeaderLayer);
        GridLayer gridLayer = new GridLayer(bodyLayer, columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        this.natTable = new NatTable(parent, (ILayer)gridLayer, false);
        this.natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        this.natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        this.natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(this.natTable){

            protected PopupMenuBuilder createColumnHeaderMenu(NatTable natTable) {
                return super.createColumnHeaderMenu(natTable).withColumnChooserMenuItem();
            }
        });
        this.natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        ColumnOverrideLabelAccumulator columnLabelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyLayer.getBodyDataLayer());
        bodyLayer.getBodyDataLayer().setConfigLabelAccumulator((IConfigLabelAccumulator)columnLabelAccumulator);
        this.natTable.addConfiguration((IConfiguration)EditableGridExample.editableGridConfiguration(columnLabelAccumulator, this.bodyDataProvider));
        this.natTable.addConfiguration((IConfiguration)new FilterRowGridExample.FilterRowCustomConfiguration());
        DisplayColumnChooserCommandHandler columnChooserCommandHandler = new DisplayColumnChooserCommandHandler(bodyLayer.getSelectionLayer(), bodyLayer.getColumnHideShowLayer(), columnHeaderLayer.getColumnHeaderLayer(), (DataLayer)columnHeaderLayer.getColumnHeaderDataLayer(), columnHeaderLayer.getColumnGroupHeaderLayer(), columnGroupModel);
        bodyLayer.registerCommandHandler((ILayerCommandHandler)columnChooserCommandHandler);
        this.natTable.addConfiguration(new MySummaryRow<BlinkingRowDataFixture>((IRowDataProvider<BlinkingRowDataFixture>)this.bodyDataProvider));
        this.natTable.configure();
        return this.natTable;
    }

    private void setUpColumnGroups(FullFeaturedColumnHeaderLayerStack<BlinkingRowDataFixture> headerLayer) {
        headerLayer.getColumnGroupHeaderLayer().addColumnsIndexesToGroup("TestGroup", new int[]{1, 2});
        headerLayer.getColumnGroupHeaderLayer().addColumnsIndexesToGroup("TestGroup1", new int[]{5, 6, 7});
        headerLayer.getColumnGroupHeaderLayer().setGroupUnbreakable(5);
        headerLayer.getColumnGroupHeaderLayer().setGroupAsCollapsed(5);
    }

    @Override
    public void onStart() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                _900_Everything_but_the_kitchen_sink.this.scheduledThreadPool = Executors.newScheduledThreadPool(1);
                System.out.println("Starting data load.");
                _900_Everything_but_the_kitchen_sink.this.scheduledThreadPool.schedule(new DataLoader(_900_Everything_but_the_kitchen_sink.this.propertyChangeListener, (EventList<BlinkingRowDataFixture>)_900_Everything_but_the_kitchen_sink.this.baseEventList), 100L, TimeUnit.MILLISECONDS);
                _900_Everything_but_the_kitchen_sink.this.scheduledThreadPool.scheduleAtFixedRate(new DataUpdater((ListDataProvider<BlinkingRowDataFixture>)_900_Everything_but_the_kitchen_sink.this.bodyDataProvider), 100L, 5000L, TimeUnit.MILLISECONDS);
            }
        });
    }

    @Override
    public void onStop() {
        if (ObjectUtils.isNotNull((Object)this.scheduledThreadPool)) {
            this.scheduledThreadPool.shutdownNow();
        }
    }

    private void registerBlinkingConfigCells(ConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(BlinkConfigAttributes.BLINK_RESOLVER, (Object)this.getBlinkResolver(), "NORMAL");
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_GREEN);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", BLINK_UP_CONFIG_LABEL);
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_RED);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", BLINK_DOWN_CONFIG_LABEL);
    }

    private IBlinkingCellResolver getBlinkResolver() {
        return new BlinkingCellResolver(){
            private final String[] configLabels = new String[1];

            public String[] resolve(Object oldValue, Object newValue) {
                double old = (Double)oldValue;
                double latest = (Double)newValue;
                this.configLabels[0] = latest > old ? _900_Everything_but_the_kitchen_sink.BLINK_UP_CONFIG_LABEL : _900_Everything_but_the_kitchen_sink.BLINK_DOWN_CONFIG_LABEL;
                return this.configLabels;
            }
        };
    }

    public Runnable runWithBusyIndicator(final Runnable runnable) {
        return new Runnable(){

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)runnable);
                    }
                });
            }
        };
    }

    class DataLoader
    implements Runnable {
        private final PropertyChangeListener changeListener;
        private final EventList<BlinkingRowDataFixture> list;
        private final String waitMsg = "Loading data. Please wait... ";
        private WaitDialog dialog;

        public DataLoader(PropertyChangeListener changeListener, EventList<BlinkingRowDataFixture> baseEventList) {
            this.changeListener = changeListener;
            this.list = baseEventList;
        }

        @Override
        public void run() {
            try {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Image icon = new Image((Device)Display.getDefault(), this.getClass().getResourceAsStream("waiting.gif"));
                        DataLoader.this.dialog = new WaitDialog(_900_Everything_but_the_kitchen_sink.this.natTable.getShell(), 0, "Loading data. Please wait... ", icon);
                        DataLoader.this.dialog.setBlockOnOpen(true);
                        DataLoader.this.dialog.open();
                    }
                });
                while (this.list.size() < 52000) {
                    ArrayList buffer = new ArrayList();
                    int i = 0;
                    while (i < 100) {
                        buffer.addAll(BlinkingRowDataFixture.getList((PropertyChangeListener)this.changeListener));
                        ++i;
                    }
                    this.list.addAll(buffer);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            DataLoader.this.dialog.setMsg(String.valueOf("Loading data. Please wait... ") + DataLoader.this.list.size());
                        }
                    });
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataLoader.this.dialog.close();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    class DataUpdater
    implements Runnable {
        ListDataProvider<BlinkingRowDataFixture> dataProvider;
        int counter = 0;

        DataUpdater(ListDataProvider<BlinkingRowDataFixture> dataProvider) {
            this.dataProvider = dataProvider;
        }

        @Override
        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < 5) {
                        int index = _900_Everything_but_the_kitchen_sink.this.random.nextInt(13);
                        int nextAsk = _900_Everything_but_the_kitchen_sink.this.random.nextInt(1000);
                        if (DataUpdater.this.dataProvider.getRowCount() > index) {
                            BlinkingRowDataFixture rowObject = (BlinkingRowDataFixture)DataUpdater.this.dataProvider.getRowObject(index);
                            rowObject.setAsk_price((double)nextAsk);
                            rowObject.setBid_price((double)(-1 * nextAsk));
                        }
                        ++i;
                    }
                }
            });
        }
    }

    class MySummaryRow<T>
    extends DefaultSummaryRowConfiguration
    implements IConfiguration {
        private IRowDataProvider<T> dataProvider;

        public MySummaryRow(IRowDataProvider<T> dataProvider) {
            this.dataProvider = dataProvider;
        }

        public void addSummaryProviderConfig(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)new SummationSummaryProvider(this.dataProvider), "NORMAL", "SummaryColumn_" + RowDataListFixture.getColumnIndexOfProperty((String)"ask_price"));
            configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)ISummaryProvider.NONE, "NORMAL", "SummaryRow");
        }
    }
}

