/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.fixtures;

import ca.odell.glazedlists.SortedList;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.stack.DefaultBodyLayerStack;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;

public class GlazedListsColumnHeaderLayerStack<T>
extends AbstractLayerTransform {
    private IDataProvider dataProvider;
    private DefaultColumnHeaderDataLayer dataLayer;
    private ColumnHeaderLayer columnHeaderLayer;

    public GlazedListsColumnHeaderLayerStack(String[] propertyNames, Map<String, String> propertyToLabelMap, SortedList<T> sortedList, IColumnPropertyAccessor<T> columnPropertyAccessor, IConfigRegistry configRegistry, DefaultBodyLayerStack bodyLayerStack) {
        this((IDataProvider)new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap), sortedList, columnPropertyAccessor, configRegistry, bodyLayerStack);
    }

    public GlazedListsColumnHeaderLayerStack(IDataProvider dataProvider, SortedList<T> sortedList, IColumnPropertyAccessor<T> columnPropertyAccessor, IConfigRegistry configRegistry, DefaultBodyLayerStack bodyLayerStack) {
        this.dataProvider = dataProvider;
        this.dataLayer = new DefaultColumnHeaderDataLayer(dataProvider);
        this.columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)this.dataLayer, (ILayer)bodyLayerStack, bodyLayerStack.getSelectionLayer());
        SortHeaderLayer sortHeaderLayer = new SortHeaderLayer((ILayer)this.columnHeaderLayer, (ISortModel)new GlazedListsSortModel(sortedList, columnPropertyAccessor, configRegistry, (ILayer)this.dataLayer), false);
        this.setUnderlyingLayer((ILayer)sortHeaderLayer);
    }

    public void setClientAreaProvider(IClientAreaProvider clientAreaProvider) {
        super.setClientAreaProvider(clientAreaProvider);
    }

    public DataLayer getDataLayer() {
        return this.dataLayer;
    }

    public IDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public ColumnHeaderLayer getColumnHeaderLayer() {
        return this.columnHeaderLayer;
    }
}

