/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.hideshow.IColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ColumnHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ColumnShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ShowAllColumnsCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.AbstractIndexLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEvent;

public class ResizeColumnHideShowLayer
extends AbstractIndexLayerTransform
implements IColumnHideShowLayer {
    public static final String PERSISTENCE_KEY_HIDDEN_COLUMNS = ".hiddenColumns";
    protected final Map<Integer, ColumnSizeInfo> hiddenColumns = new TreeMap<Integer, ColumnSizeInfo>();
    private DataLayer bodyDataLayer;

    public ResizeColumnHideShowLayer(IUniqueIndexLayer underlyingLayer, DataLayer bodyDataLayer) {
        super(underlyingLayer);
        this.bodyDataLayer = bodyDataLayer;
        this.registerCommandHandler(new ColumnHideCommandHandler(this));
        this.registerCommandHandler(new MultiColumnHideCommandHandler(this));
        this.registerCommandHandler(new ShowAllColumnsCommandHandler(this));
        this.registerCommandHandler(new MultiColumnShowCommandHandler(this));
        this.registerCommandHandler(new ColumnShowCommandHandler(this));
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        this.saveMap(this.hiddenColumns, String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_COLUMNS, properties);
        super.saveState(prefix, properties);
    }

    private void saveMap(Map<?, ?> map, String key, Properties properties) {
        if (map.size() > 0) {
            StringBuilder strBuilder = new StringBuilder();
            for (Object index : map.keySet()) {
                strBuilder.append(index);
                strBuilder.append(':');
                strBuilder.append(map.get(index));
                strBuilder.append(',');
            }
            properties.setProperty(key, strBuilder.toString());
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        this.hiddenColumns.clear();
        this.loadMap(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_COLUMNS, properties, this.hiddenColumns);
        super.loadState(prefix, properties);
    }

    private void loadMap(String key, Properties properties, Map<Integer, ColumnSizeInfo> map) {
        String property = properties.getProperty(key);
        if (property != null) {
            map.clear();
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int separatorIndex = token.indexOf(58);
                map.put(Integer.valueOf(token.substring(0, separatorIndex)), ColumnSizeInfo.valueOf(token.substring(separatorIndex + 1)));
            }
        }
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack labels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        if (this.hiddenColumns.containsKey(this.getColumnIndexByPosition(columnPosition))) {
            labels.addLabel("SKIP_SEARCH_RESULT");
        }
        if (this.hiddenColumns.containsKey(this.getColumnIndexByPosition(columnPosition - 1))) {
            labels.addLabel("COLUMN_LEFT_HIDDEN");
        }
        if (this.hiddenColumns.containsKey(this.getColumnIndexByPosition(columnPosition + 1))) {
            labels.addLabel("COLUMN_RIGHT_HIDDEN");
        }
        return labels;
    }

    @Override
    public Collection<Integer> getHiddenColumnIndexes() {
        return this.hiddenColumns.keySet();
    }

    @Override
    public void hideColumnPositions(Integer ... columnPositions) {
        this.hideColumnPositions(Arrays.asList(columnPositions));
    }

    @Override
    public void hideColumnPositions(Collection<Integer> columnPositions) {
        TreeMap<Integer, ColumnSizeInfo> positionsToHide = new TreeMap<Integer, ColumnSizeInfo>();
        boolean fix = this.bodyDataLayer.isFixColumnPercentageValuesOnResize();
        this.bodyDataLayer.setFixColumnPercentageValuesOnResize(false);
        for (Integer columnPosition : columnPositions) {
            int columnIndex = this.getColumnIndexByPosition(columnPosition);
            if (this.hiddenColumns.containsKey(columnIndex)) continue;
            int configuredWidth = this.bodyDataLayer.getConfiguredColumnWidthByPosition(columnIndex);
            int configuredMinWidth = this.bodyDataLayer.getConfiguredMinColumnWidthByPosition(columnIndex);
            boolean configuredResizable = this.bodyDataLayer.isColumnPositionResizable(columnIndex);
            boolean configuredPercentage = this.bodyDataLayer.isColumnPercentageSizing(columnIndex);
            double configuredPercentageValue = this.bodyDataLayer.getConfiguredColumnWidthPercentageByPosition(columnIndex);
            positionsToHide.put(columnIndex, new ColumnSizeInfo(configuredWidth, configuredMinWidth, configuredResizable, configuredPercentage, configuredPercentageValue));
        }
        for (Integer columnIndex : positionsToHide.keySet()) {
            if (!this.bodyDataLayer.isColumnPositionResizable(columnIndex)) {
                this.bodyDataLayer.setColumnPositionResizable(columnIndex, true);
            }
            if (this.bodyDataLayer.isMinColumnWidthConfigured()) {
                this.bodyDataLayer.setMinColumnWidth(columnIndex, 0);
            }
            if (((ColumnSizeInfo)positionsToHide.get((Object)columnIndex)).configuredPercentage) {
                this.bodyDataLayer.setColumnWidthPercentageByPosition((int)columnIndex, 0.0);
            } else {
                this.bodyDataLayer.setColumnWidthByPosition(columnIndex, 0, false);
            }
            this.bodyDataLayer.setColumnPositionResizable(columnIndex, false);
        }
        this.hiddenColumns.putAll(positionsToHide);
        this.bodyDataLayer.setFixColumnPercentageValuesOnResize(fix);
        List<Range> ranges = PositionUtil.getRanges(positionsToHide.keySet());
        for (Range range : ranges) {
            this.bodyDataLayer.fireLayerEvent(new ColumnResizeEvent((ILayer)this.bodyDataLayer, range));
        }
    }

    @Override
    public void showColumnIndexes(Integer ... columnIndexes) {
        this.showColumnIndexes(Arrays.asList(columnIndexes));
    }

    @Override
    public void showColumnIndexes(Collection<Integer> columnIndexes) {
        ArrayList<Integer> toProcess = new ArrayList<Integer>(columnIndexes);
        toProcess.retainAll(this.hiddenColumns.keySet());
        boolean fix = this.bodyDataLayer.isFixColumnPercentageValuesOnResize();
        this.bodyDataLayer.setFixColumnPercentageValuesOnResize(false);
        ArrayList<Integer> processed = new ArrayList<Integer>();
        for (Integer index : toProcess) {
            ColumnSizeInfo info = this.hiddenColumns.remove(index);
            if (info == null) continue;
            processed.add(index);
            this.bodyDataLayer.setColumnPositionResizable(index, true);
            if (info.configuredPercentage && info.configuredPercentageValue >= 0.0) {
                this.bodyDataLayer.setColumnWidthPercentageByPosition((int)index, info.configuredPercentageValue);
            } else if (!info.configuredPercentage && info.configuredSize >= 0) {
                this.bodyDataLayer.setColumnWidthByPosition(index, info.configuredSize, false);
            } else {
                this.bodyDataLayer.resetColumnWidth(index, false);
            }
            this.bodyDataLayer.setColumnPositionResizable(index, info.configuredResizable);
            if (info.configuredMinWidth < 0) {
                this.bodyDataLayer.resetMinColumnWidth(index, false);
                continue;
            }
            this.bodyDataLayer.setMinColumnWidth(index, info.configuredMinWidth);
        }
        this.bodyDataLayer.setFixColumnPercentageValuesOnResize(fix);
        if (!processed.isEmpty()) {
            List<Range> ranges = PositionUtil.getRanges(processed);
            for (Range range : ranges) {
                this.bodyDataLayer.fireLayerEvent(new ColumnResizeEvent((ILayer)this.bodyDataLayer, range));
            }
        }
    }

    @Override
    public void showColumnPosition(int columnPosition, boolean showToLeft, boolean showAll) {
        HashSet<Integer> columnIndexes = new HashSet<Integer>();
        if (showToLeft) {
            int leftColumnIndex = this.getColumnIndexByPosition(columnPosition - 1);
            if (showAll) {
                int move = 1;
                while (this.hiddenColumns.containsKey(leftColumnIndex)) {
                    columnIndexes.add(leftColumnIndex);
                    leftColumnIndex = this.getColumnIndexByPosition(columnPosition - ++move);
                }
            } else if (this.hiddenColumns.containsKey(leftColumnIndex)) {
                columnIndexes.add(leftColumnIndex);
            }
        } else {
            int rightColumnIndex = this.getColumnIndexByPosition(columnPosition + 1);
            if (showAll) {
                int move = 1;
                while (this.hiddenColumns.containsKey(rightColumnIndex)) {
                    columnIndexes.add(rightColumnIndex);
                    rightColumnIndex = this.getColumnIndexByPosition(columnPosition + ++move);
                }
            } else if (this.hiddenColumns.containsKey(rightColumnIndex)) {
                columnIndexes.add(rightColumnIndex);
            }
        }
        if (!columnIndexes.isEmpty()) {
            this.showColumnIndexes(columnIndexes);
        }
    }

    @Override
    public void showAllColumns() {
        boolean fix = this.bodyDataLayer.isFixColumnPercentageValuesOnResize();
        this.bodyDataLayer.setFixColumnPercentageValuesOnResize(false);
        for (Map.Entry<Integer, ColumnSizeInfo> entry : this.hiddenColumns.entrySet()) {
            Integer index = entry.getKey();
            ColumnSizeInfo info = entry.getValue();
            this.bodyDataLayer.setColumnPositionResizable(index, true);
            if (info.configuredMinWidth < 0) {
                this.bodyDataLayer.resetMinColumnWidth(index, false);
            } else {
                this.bodyDataLayer.setMinColumnWidth(index, info.configuredMinWidth);
            }
            if (info.configuredPercentage && info.configuredPercentageValue >= 0.0) {
                this.bodyDataLayer.setColumnWidthPercentageByPosition((int)index, info.configuredPercentageValue);
            } else if (!info.configuredPercentage && info.configuredSize >= 0) {
                this.bodyDataLayer.setColumnWidthByPosition(index, info.configuredSize, false);
            } else {
                this.bodyDataLayer.resetColumnWidth(index, false);
            }
            this.bodyDataLayer.setColumnPositionResizable(index, info.configuredResizable);
        }
        List<Range> ranges = PositionUtil.getRanges(this.hiddenColumns.keySet());
        this.hiddenColumns.clear();
        this.bodyDataLayer.setFixColumnPercentageValuesOnResize(fix);
        for (Range range : ranges) {
            this.bodyDataLayer.fireLayerEvent(new ColumnResizeEvent((ILayer)this.bodyDataLayer, range));
        }
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> result = super.getProvidedLabels();
        result.add("COLUMN_LEFT_HIDDEN");
        result.add("COLUMN_RIGHT_HIDDEN");
        return result;
    }

    protected static class ColumnSizeInfo {
        public final int configuredSize;
        public final int configuredMinWidth;
        public final boolean configuredResizable;
        public final boolean configuredPercentage;
        public final double configuredPercentageValue;

        public ColumnSizeInfo(int configuredSize, int configuredMinWidth, boolean configuredResizable, boolean configuredPercentage, double configuredPercentageValue) {
            this.configuredSize = configuredSize;
            this.configuredMinWidth = configuredMinWidth;
            this.configuredResizable = configuredResizable;
            this.configuredPercentage = configuredPercentage;
            this.configuredPercentageValue = configuredPercentageValue;
        }

        public static ColumnSizeInfo valueOf(String s) {
            String[] token = s.substring(1, s.length() - 1).split("\\|");
            Integer size = Integer.valueOf(token[0]);
            Integer minWidth = Integer.valueOf(token[1]);
            Boolean resizable = Boolean.valueOf(token[2]);
            Boolean percentage = Boolean.valueOf(token[3]);
            Double percentageValue = Double.valueOf(token[4]);
            return new ColumnSizeInfo(size, minWidth, resizable, percentage, percentageValue);
        }

        public String toString() {
            return "[" + this.configuredSize + "|" + this.configuredMinWidth + "|" + this.configuredResizable + "|" + this.configuredPercentage + "|" + this.configuredPercentageValue + "]";
        }
    }
}

