/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.hierarchical;

import ca.odell.glazedlists.SortedList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.NullComparator;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.hierarchical.HierarchicalWrapper;
import org.eclipse.nebula.widgets.nattable.hierarchical.HierarchicalWrapperComparator;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortConfigAttributes;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;

public class HierarchicalWrapperSortModel
implements ISortModel {
    private SortedList<HierarchicalWrapper> sortedList;
    private IColumnAccessor<HierarchicalWrapper> columnAccessor;
    private Map<Integer, List<Integer>> levelIndexMapping;
    private DataLayer columnHeaderDataLayer;
    private ConfigRegistry configRegistry;
    private Map<Integer, SortDirectionEnum> sortingState = new LinkedHashMap<Integer, SortDirectionEnum>();

    public HierarchicalWrapperSortModel(SortedList<HierarchicalWrapper> sortedList, IColumnAccessor<HierarchicalWrapper> columnAccessor, Map<Integer, List<Integer>> levelIndexMapping, DataLayer columnHeaderDataLayer, ConfigRegistry configRegistry) {
        this.sortedList = sortedList;
        this.columnAccessor = columnAccessor;
        this.columnHeaderDataLayer = columnHeaderDataLayer;
        this.levelIndexMapping = levelIndexMapping;
        this.configRegistry = configRegistry;
    }

    public List<Integer> getSortedColumnIndexes() {
        return new ArrayList<Integer>(this.sortingState.keySet());
    }

    public boolean isColumnIndexSorted(int columnIndex) {
        return this.sortingState.containsKey(columnIndex);
    }

    public SortDirectionEnum getSortDirection(int columnIndex) {
        SortDirectionEnum sort = this.sortingState.get(columnIndex);
        return sort != null ? sort : SortDirectionEnum.NONE;
    }

    public int getSortOrder(int columnIndex) {
        int index = this.getSortedColumnIndexes().indexOf(columnIndex);
        return index >= 0 ? index : 0;
    }

    public List<Comparator> getComparatorsForColumnIndex(int columnIndex) {
        SortDirectionEnum sort = this.sortingState.get(columnIndex);
        if (sort == null) {
            return null;
        }
        ArrayList<Comparator> result = new ArrayList<Comparator>();
        result.add(this.getColumnComparator(columnIndex));
        return result;
    }

    public Comparator<?> getColumnComparator(int columnIndex) {
        ILayerCell cell = this.columnHeaderDataLayer.getCellByPosition(columnIndex, 0);
        if (cell == null) {
            return null;
        }
        Comparator comparator = (Comparator)this.configRegistry.getConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
        return comparator instanceof NullComparator ? null : comparator;
    }

    public void sort(int columnIndex, SortDirectionEnum sortDirection, boolean accumulate) {
        if (columnIndex >= 0) {
            if (!accumulate) {
                this.clear();
            }
            switch (sortDirection) {
                case NONE: {
                    this.sortingState.remove(columnIndex);
                    break;
                }
                case ASC: 
                case DESC: {
                    this.sortingState.remove(columnIndex);
                    this.sortingState.put(columnIndex, sortDirection);
                    break;
                }
            }
            this.sortedList.getReadWriteLock().writeLock().lock();
            try {
                if (this.sortingState.isEmpty()) {
                    this.sortedList.setComparator(null);
                } else {
                    this.sortedList.setComparator((Comparator)new HierarchicalWrapperComparator(this.columnAccessor, this.levelIndexMapping, (ISortModel)this));
                }
            }
            finally {
                this.sortedList.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    public void clear() {
        this.sortingState.clear();
    }
}

